/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.typedspan;

import io.opentelemetry.auto.typedspan.DelegatingSpan;
import io.opentelemetry.auto.typedspan.NetworkSemanticConvention;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.Tracer;

public class NetworkSpan
extends DelegatingSpan
implements NetworkSemanticConvention {
    protected NetworkSpan(Span span) {
        super(span);
    }

    public static NetworkSpanBuilder createNetworkSpan(Tracer tracer, String spanName) {
        return new NetworkSpanBuilder(tracer, spanName);
    }

    @Override
    public Span getSpan() {
        return this.delegate;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public NetworkSemanticConvention setNetTransport(String netTransport) {
        this.delegate.setAttribute("net.transport", netTransport);
        return this;
    }

    @Override
    public NetworkSemanticConvention setNetPeerIp(String netPeerIp) {
        this.delegate.setAttribute("net.peer.ip", netPeerIp);
        return this;
    }

    @Override
    public NetworkSemanticConvention setNetPeerPort(long netPeerPort) {
        this.delegate.setAttribute("net.peer.port", netPeerPort);
        return this;
    }

    @Override
    public NetworkSemanticConvention setNetPeerName(String netPeerName) {
        this.delegate.setAttribute("net.peer.name", netPeerName);
        return this;
    }

    @Override
    public NetworkSemanticConvention setNetHostIp(String netHostIp) {
        this.delegate.setAttribute("net.host.ip", netHostIp);
        return this;
    }

    @Override
    public NetworkSemanticConvention setNetHostPort(long netHostPort) {
        this.delegate.setAttribute("net.host.port", netHostPort);
        return this;
    }

    @Override
    public NetworkSemanticConvention setNetHostName(String netHostName) {
        this.delegate.setAttribute("net.host.name", netHostName);
        return this;
    }

    public static class NetworkSpanBuilder {
        protected Span.Builder internalBuilder;

        protected NetworkSpanBuilder(Tracer tracer, String spanName) {
            this.internalBuilder = tracer.spanBuilder(spanName);
        }

        public NetworkSpanBuilder(Span.Builder spanBuilder) {
            this.internalBuilder = spanBuilder;
        }

        public Span.Builder getSpanBuilder() {
            return this.internalBuilder;
        }

        public NetworkSpanBuilder setParent(Span parent) {
            this.internalBuilder.setParent(parent);
            return this;
        }

        public NetworkSpanBuilder setParent(SpanContext remoteParent) {
            this.internalBuilder.setParent(remoteParent);
            return this;
        }

        public NetworkSpanBuilder setKind(Span.Kind kind) {
            this.internalBuilder.setSpanKind(kind);
            return this;
        }

        public NetworkSpan start() {
            return new NetworkSpan(this.internalBuilder.startSpan());
        }

        public NetworkSpanBuilder setNetTransport(String netTransport) {
            this.internalBuilder.setAttribute("net.transport", netTransport);
            return this;
        }

        public NetworkSpanBuilder setNetPeerIp(String netPeerIp) {
            this.internalBuilder.setAttribute("net.peer.ip", netPeerIp);
            return this;
        }

        public NetworkSpanBuilder setNetPeerPort(long netPeerPort) {
            this.internalBuilder.setAttribute("net.peer.port", netPeerPort);
            return this;
        }

        public NetworkSpanBuilder setNetPeerName(String netPeerName) {
            this.internalBuilder.setAttribute("net.peer.name", netPeerName);
            return this;
        }

        public NetworkSpanBuilder setNetHostIp(String netHostIp) {
            this.internalBuilder.setAttribute("net.host.ip", netHostIp);
            return this;
        }

        public NetworkSpanBuilder setNetHostPort(long netHostPort) {
            this.internalBuilder.setAttribute("net.host.port", netHostPort);
            return this;
        }

        public NetworkSpanBuilder setNetHostName(String netHostName) {
            this.internalBuilder.setAttribute("net.host.name", netHostName);
            return this;
        }
    }
}

