/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.typedspan;

import io.opentelemetry.auto.typedspan.DelegatingSpan;
import io.opentelemetry.auto.typedspan.MessagingConsumerSemanticConvention;
import io.opentelemetry.auto.typedspan.MessagingSpan;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.Tracer;

public class MessagingConsumerSpan
extends DelegatingSpan
implements MessagingConsumerSemanticConvention {
    protected MessagingConsumerSpan(Span span) {
        super(span);
    }

    public static MessagingConsumerSpanBuilder createMessagingConsumerSpan(Tracer tracer, String spanName) {
        return new MessagingConsumerSpanBuilder(tracer, spanName).setKind(Span.Kind.CONSUMER);
    }

    public static MessagingConsumerSpanBuilder createMessagingConsumerSpan(MessagingSpan.MessagingSpanBuilder builder) {
        return new MessagingConsumerSpanBuilder(builder.getSpanBuilder());
    }

    @Override
    public Span getSpan() {
        return this.delegate;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public MessagingConsumerSemanticConvention setNetPeerIp(String netPeerIp) {
        this.delegate.setAttribute("net.peer.ip", netPeerIp);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setNetPeerName(String netPeerName) {
        this.delegate.setAttribute("net.peer.name", netPeerName);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setNetHostIp(String netHostIp) {
        this.delegate.setAttribute("net.host.ip", netHostIp);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setNetHostPort(long netHostPort) {
        this.delegate.setAttribute("net.host.port", netHostPort);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setNetHostName(String netHostName) {
        this.delegate.setAttribute("net.host.name", netHostName);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setMessagingSystem(String messagingSystem) {
        this.delegate.setAttribute("messaging.system", messagingSystem);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setMessagingDestination(String messagingDestination) {
        this.delegate.setAttribute("messaging.destination", messagingDestination);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setMessagingDestinationKind(String messagingDestinationKind) {
        this.delegate.setAttribute("messaging.destination_kind", messagingDestinationKind);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setMessagingTempDestination(boolean messagingTempDestination) {
        this.delegate.setAttribute("messaging.temp_destination", messagingTempDestination);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setMessagingProtocol(String messagingProtocol) {
        this.delegate.setAttribute("messaging.protocol", messagingProtocol);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setMessagingProtocolVersion(String messagingProtocolVersion) {
        this.delegate.setAttribute("messaging.protocol_version", messagingProtocolVersion);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setMessagingUrl(String messagingUrl) {
        this.delegate.setAttribute("messaging.url", messagingUrl);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setMessagingMessageId(String messagingMessageId) {
        this.delegate.setAttribute("messaging.message_id", messagingMessageId);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setMessagingConversationId(String messagingConversationId) {
        this.delegate.setAttribute("messaging.conversation_id", messagingConversationId);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setMessagingMessagePayloadSizeBytes(long messagingMessagePayloadSizeBytes) {
        this.delegate.setAttribute("messaging.message_payload_size_bytes", messagingMessagePayloadSizeBytes);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setMessagingMessagePayloadCompressedSizeBytes(long messagingMessagePayloadCompressedSizeBytes) {
        this.delegate.setAttribute("messaging.message_payload_compressed_size_bytes", messagingMessagePayloadCompressedSizeBytes);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setNetPeerPort(long netPeerPort) {
        this.delegate.setAttribute("net.peer.port", netPeerPort);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setNetTransport(String netTransport) {
        this.delegate.setAttribute("net.transport", netTransport);
        return this;
    }

    @Override
    public MessagingConsumerSemanticConvention setMessagingOperation(String messagingOperation) {
        this.delegate.setAttribute("messaging.operation", messagingOperation);
        return this;
    }

    public static class MessagingConsumerSpanBuilder {
        protected Span.Builder internalBuilder;

        protected MessagingConsumerSpanBuilder(Tracer tracer, String spanName) {
            this.internalBuilder = tracer.spanBuilder(spanName);
        }

        public MessagingConsumerSpanBuilder(Span.Builder spanBuilder) {
            this.internalBuilder = spanBuilder;
        }

        public Span.Builder getSpanBuilder() {
            return this.internalBuilder;
        }

        public MessagingConsumerSpanBuilder setParent(Span parent) {
            this.internalBuilder.setParent(parent);
            return this;
        }

        public MessagingConsumerSpanBuilder setParent(SpanContext remoteParent) {
            this.internalBuilder.setParent(remoteParent);
            return this;
        }

        public MessagingConsumerSpanBuilder setKind(Span.Kind kind) {
            this.internalBuilder.setSpanKind(kind);
            return this;
        }

        public MessagingConsumerSpan start() {
            return new MessagingConsumerSpan(this.internalBuilder.startSpan());
        }

        public MessagingConsumerSpanBuilder setNetPeerIp(String netPeerIp) {
            this.internalBuilder.setAttribute("net.peer.ip", netPeerIp);
            return this;
        }

        public MessagingConsumerSpanBuilder setNetPeerName(String netPeerName) {
            this.internalBuilder.setAttribute("net.peer.name", netPeerName);
            return this;
        }

        public MessagingConsumerSpanBuilder setNetHostIp(String netHostIp) {
            this.internalBuilder.setAttribute("net.host.ip", netHostIp);
            return this;
        }

        public MessagingConsumerSpanBuilder setNetHostPort(long netHostPort) {
            this.internalBuilder.setAttribute("net.host.port", netHostPort);
            return this;
        }

        public MessagingConsumerSpanBuilder setNetHostName(String netHostName) {
            this.internalBuilder.setAttribute("net.host.name", netHostName);
            return this;
        }

        public MessagingConsumerSpanBuilder setMessagingSystem(String messagingSystem) {
            this.internalBuilder.setAttribute("messaging.system", messagingSystem);
            return this;
        }

        public MessagingConsumerSpanBuilder setMessagingDestination(String messagingDestination) {
            this.internalBuilder.setAttribute("messaging.destination", messagingDestination);
            return this;
        }

        public MessagingConsumerSpanBuilder setMessagingDestinationKind(String messagingDestinationKind) {
            this.internalBuilder.setAttribute("messaging.destination_kind", messagingDestinationKind);
            return this;
        }

        public MessagingConsumerSpanBuilder setMessagingTempDestination(boolean messagingTempDestination) {
            this.internalBuilder.setAttribute("messaging.temp_destination", messagingTempDestination);
            return this;
        }

        public MessagingConsumerSpanBuilder setMessagingProtocol(String messagingProtocol) {
            this.internalBuilder.setAttribute("messaging.protocol", messagingProtocol);
            return this;
        }

        public MessagingConsumerSpanBuilder setMessagingProtocolVersion(String messagingProtocolVersion) {
            this.internalBuilder.setAttribute("messaging.protocol_version", messagingProtocolVersion);
            return this;
        }

        public MessagingConsumerSpanBuilder setMessagingUrl(String messagingUrl) {
            this.internalBuilder.setAttribute("messaging.url", messagingUrl);
            return this;
        }

        public MessagingConsumerSpanBuilder setMessagingMessageId(String messagingMessageId) {
            this.internalBuilder.setAttribute("messaging.message_id", messagingMessageId);
            return this;
        }

        public MessagingConsumerSpanBuilder setMessagingConversationId(String messagingConversationId) {
            this.internalBuilder.setAttribute("messaging.conversation_id", messagingConversationId);
            return this;
        }

        public MessagingConsumerSpanBuilder setMessagingMessagePayloadSizeBytes(long messagingMessagePayloadSizeBytes) {
            this.internalBuilder.setAttribute("messaging.message_payload_size_bytes", messagingMessagePayloadSizeBytes);
            return this;
        }

        public MessagingConsumerSpanBuilder setMessagingMessagePayloadCompressedSizeBytes(long messagingMessagePayloadCompressedSizeBytes) {
            this.internalBuilder.setAttribute("messaging.message_payload_compressed_size_bytes", messagingMessagePayloadCompressedSizeBytes);
            return this;
        }

        public MessagingConsumerSpanBuilder setNetPeerPort(long netPeerPort) {
            this.internalBuilder.setAttribute("net.peer.port", netPeerPort);
            return this;
        }

        public MessagingConsumerSpanBuilder setNetTransport(String netTransport) {
            this.internalBuilder.setAttribute("net.transport", netTransport);
            return this;
        }

        public MessagingConsumerSpanBuilder setMessagingOperation(String messagingOperation) {
            this.internalBuilder.setAttribute("messaging.operation", messagingOperation);
            return this;
        }
    }
}

