/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.typedspan;

import io.opentelemetry.auto.typedspan.DelegatingSpan;
import io.opentelemetry.auto.typedspan.GrpcServerSemanticConvention;
import io.opentelemetry.auto.typedspan.RpcSpan;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.Tracer;

public class GrpcServerSpan
extends DelegatingSpan
implements GrpcServerSemanticConvention {
    protected GrpcServerSpan(Span span) {
        super(span);
    }

    public static GrpcServerSpanBuilder createGrpcServerSpan(Tracer tracer, String spanName) {
        return new GrpcServerSpanBuilder(tracer, spanName).setKind(Span.Kind.SERVER);
    }

    public static GrpcServerSpanBuilder createGrpcServerSpan(RpcSpan.RpcSpanBuilder builder) {
        return new GrpcServerSpanBuilder(builder.getSpanBuilder());
    }

    @Override
    public Span getSpan() {
        return this.delegate;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public GrpcServerSemanticConvention setNetTransport(String netTransport) {
        this.delegate.setAttribute("net.transport", netTransport);
        return this;
    }

    @Override
    public GrpcServerSemanticConvention setNetPeerIp(String netPeerIp) {
        this.delegate.setAttribute("net.peer.ip", netPeerIp);
        return this;
    }

    @Override
    public GrpcServerSemanticConvention setNetPeerPort(long netPeerPort) {
        this.delegate.setAttribute("net.peer.port", netPeerPort);
        return this;
    }

    @Override
    public GrpcServerSemanticConvention setNetPeerName(String netPeerName) {
        this.delegate.setAttribute("net.peer.name", netPeerName);
        return this;
    }

    @Override
    public GrpcServerSemanticConvention setNetHostIp(String netHostIp) {
        this.delegate.setAttribute("net.host.ip", netHostIp);
        return this;
    }

    @Override
    public GrpcServerSemanticConvention setNetHostPort(long netHostPort) {
        this.delegate.setAttribute("net.host.port", netHostPort);
        return this;
    }

    @Override
    public GrpcServerSemanticConvention setNetHostName(String netHostName) {
        this.delegate.setAttribute("net.host.name", netHostName);
        return this;
    }

    @Override
    public GrpcServerSemanticConvention setRpcService(String rpcService) {
        this.delegate.setAttribute("rpc.service", rpcService);
        return this;
    }

    public static class GrpcServerSpanBuilder {
        protected Span.Builder internalBuilder;

        protected GrpcServerSpanBuilder(Tracer tracer, String spanName) {
            this.internalBuilder = tracer.spanBuilder(spanName);
        }

        public GrpcServerSpanBuilder(Span.Builder spanBuilder) {
            this.internalBuilder = spanBuilder;
        }

        public Span.Builder getSpanBuilder() {
            return this.internalBuilder;
        }

        public GrpcServerSpanBuilder setParent(Span parent) {
            this.internalBuilder.setParent(parent);
            return this;
        }

        public GrpcServerSpanBuilder setParent(SpanContext remoteParent) {
            this.internalBuilder.setParent(remoteParent);
            return this;
        }

        public GrpcServerSpanBuilder setKind(Span.Kind kind) {
            this.internalBuilder.setSpanKind(kind);
            return this;
        }

        public GrpcServerSpan start() {
            return new GrpcServerSpan(this.internalBuilder.startSpan());
        }

        public GrpcServerSpanBuilder setNetTransport(String netTransport) {
            this.internalBuilder.setAttribute("net.transport", netTransport);
            return this;
        }

        public GrpcServerSpanBuilder setNetPeerIp(String netPeerIp) {
            this.internalBuilder.setAttribute("net.peer.ip", netPeerIp);
            return this;
        }

        public GrpcServerSpanBuilder setNetPeerPort(long netPeerPort) {
            this.internalBuilder.setAttribute("net.peer.port", netPeerPort);
            return this;
        }

        public GrpcServerSpanBuilder setNetPeerName(String netPeerName) {
            this.internalBuilder.setAttribute("net.peer.name", netPeerName);
            return this;
        }

        public GrpcServerSpanBuilder setNetHostIp(String netHostIp) {
            this.internalBuilder.setAttribute("net.host.ip", netHostIp);
            return this;
        }

        public GrpcServerSpanBuilder setNetHostPort(long netHostPort) {
            this.internalBuilder.setAttribute("net.host.port", netHostPort);
            return this;
        }

        public GrpcServerSpanBuilder setNetHostName(String netHostName) {
            this.internalBuilder.setAttribute("net.host.name", netHostName);
            return this;
        }

        public GrpcServerSpanBuilder setRpcService(String rpcService) {
            this.internalBuilder.setAttribute("rpc.service", rpcService);
            return this;
        }
    }
}

