/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.typedspan;

import io.opentelemetry.auto.typedspan.DelegatingSpan;
import io.opentelemetry.auto.typedspan.GrpcClientSemanticConvention;
import io.opentelemetry.auto.typedspan.RpcSpan;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.Tracer;

public class GrpcClientSpan
extends DelegatingSpan
implements GrpcClientSemanticConvention {
    protected GrpcClientSpan(Span span) {
        super(span);
    }

    public static GrpcClientSpanBuilder createGrpcClientSpan(Tracer tracer, String spanName) {
        return new GrpcClientSpanBuilder(tracer, spanName).setKind(Span.Kind.CLIENT);
    }

    public static GrpcClientSpanBuilder createGrpcClientSpan(RpcSpan.RpcSpanBuilder builder) {
        return new GrpcClientSpanBuilder(builder.getSpanBuilder());
    }

    @Override
    public Span getSpan() {
        return this.delegate;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public GrpcClientSemanticConvention setNetTransport(String netTransport) {
        this.delegate.setAttribute("net.transport", netTransport);
        return this;
    }

    @Override
    public GrpcClientSemanticConvention setNetPeerIp(String netPeerIp) {
        this.delegate.setAttribute("net.peer.ip", netPeerIp);
        return this;
    }

    @Override
    public GrpcClientSemanticConvention setNetPeerPort(long netPeerPort) {
        this.delegate.setAttribute("net.peer.port", netPeerPort);
        return this;
    }

    @Override
    public GrpcClientSemanticConvention setNetPeerName(String netPeerName) {
        this.delegate.setAttribute("net.peer.name", netPeerName);
        return this;
    }

    @Override
    public GrpcClientSemanticConvention setNetHostIp(String netHostIp) {
        this.delegate.setAttribute("net.host.ip", netHostIp);
        return this;
    }

    @Override
    public GrpcClientSemanticConvention setNetHostPort(long netHostPort) {
        this.delegate.setAttribute("net.host.port", netHostPort);
        return this;
    }

    @Override
    public GrpcClientSemanticConvention setNetHostName(String netHostName) {
        this.delegate.setAttribute("net.host.name", netHostName);
        return this;
    }

    @Override
    public GrpcClientSemanticConvention setRpcService(String rpcService) {
        this.delegate.setAttribute("rpc.service", rpcService);
        return this;
    }

    public static class GrpcClientSpanBuilder {
        protected Span.Builder internalBuilder;

        protected GrpcClientSpanBuilder(Tracer tracer, String spanName) {
            this.internalBuilder = tracer.spanBuilder(spanName);
        }

        public GrpcClientSpanBuilder(Span.Builder spanBuilder) {
            this.internalBuilder = spanBuilder;
        }

        public Span.Builder getSpanBuilder() {
            return this.internalBuilder;
        }

        public GrpcClientSpanBuilder setParent(Span parent) {
            this.internalBuilder.setParent(parent);
            return this;
        }

        public GrpcClientSpanBuilder setParent(SpanContext remoteParent) {
            this.internalBuilder.setParent(remoteParent);
            return this;
        }

        public GrpcClientSpanBuilder setKind(Span.Kind kind) {
            this.internalBuilder.setSpanKind(kind);
            return this;
        }

        public GrpcClientSpan start() {
            return new GrpcClientSpan(this.internalBuilder.startSpan());
        }

        public GrpcClientSpanBuilder setNetTransport(String netTransport) {
            this.internalBuilder.setAttribute("net.transport", netTransport);
            return this;
        }

        public GrpcClientSpanBuilder setNetPeerIp(String netPeerIp) {
            this.internalBuilder.setAttribute("net.peer.ip", netPeerIp);
            return this;
        }

        public GrpcClientSpanBuilder setNetPeerPort(long netPeerPort) {
            this.internalBuilder.setAttribute("net.peer.port", netPeerPort);
            return this;
        }

        public GrpcClientSpanBuilder setNetPeerName(String netPeerName) {
            this.internalBuilder.setAttribute("net.peer.name", netPeerName);
            return this;
        }

        public GrpcClientSpanBuilder setNetHostIp(String netHostIp) {
            this.internalBuilder.setAttribute("net.host.ip", netHostIp);
            return this;
        }

        public GrpcClientSpanBuilder setNetHostPort(long netHostPort) {
            this.internalBuilder.setAttribute("net.host.port", netHostPort);
            return this;
        }

        public GrpcClientSpanBuilder setNetHostName(String netHostName) {
            this.internalBuilder.setAttribute("net.host.name", netHostName);
            return this;
        }

        public GrpcClientSpanBuilder setRpcService(String rpcService) {
            this.internalBuilder.setAttribute("rpc.service", rpcService);
            return this;
        }
    }
}

