/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup();
    private static final String PREFIX = "otel.";
    private static final Pattern ENV_REPLACEMENT = Pattern.compile("[^a-zA-Z0-9_]");
    public static final String EXPORTER_JAR = "exporter.jar";
    public static final String EXPORTER = "exporter";
    public static final String PROPAGATORS = "propagators";
    public static final String CONFIGURATION_FILE = "trace.config";
    public static final String TRACE_ENABLED = "trace.enabled";
    public static final String INTEGRATIONS_ENABLED = "integrations.enabled";
    public static final String TRACE_ANNOTATIONS = "trace.annotations";
    public static final String TRACE_EXECUTORS_ALL = "trace.executors.all";
    public static final String TRACE_EXECUTORS = "trace.executors";
    public static final String TRACE_METHODS = "trace.methods";
    public static final String TRACE_ANNOTATED_METHODS_EXCLUDE = "trace.annotated.methods.exclude";
    public static final String TRACE_CLASSES_EXCLUDE = "trace.classes.exclude";
    public static final String HTTP_SERVER_ERROR_STATUSES = "http.server.error.statuses";
    public static final String HTTP_CLIENT_ERROR_STATUSES = "http.client.error.statuses";
    public static final String HTTP_SERVER_TAG_QUERY_STRING = "http.server.tag.query-string";
    public static final String HTTP_CLIENT_TAG_QUERY_STRING = "http.client.tag.query-string";
    public static final String SCOPE_DEPTH_LIMIT = "trace.scope.depth.limit";
    public static final String RUNTIME_CONTEXT_FIELD_INJECTION = "trace.runtime.context.field.injection";
    public static final String KAFKA_CLIENT_PROPAGATION_ENABLED = "kafka.client.propagation.enabled";
    public static final String LOG_INJECTION_ENABLED = "log.injection.enabled";
    public static final String EXPERIMENTAL_LOG_CAPTURE_THRESHOLD = "experimental.log.capture.threshold";
    public static final String ENDPOINT_PEER_SERVICE_MAPPING = "endpoint.peer.service.mapping";
    private static final boolean DEFAULT_TRACE_ENABLED = true;
    public static final boolean DEFAULT_INTEGRATIONS_ENABLED = true;
    private static final boolean DEFAULT_RUNTIME_CONTEXT_FIELD_INJECTION = true;
    private static final boolean DEFAULT_HTTP_SERVER_TAG_QUERY_STRING = false;
    private static final boolean DEFAULT_HTTP_CLIENT_TAG_QUERY_STRING = false;
    private static final int DEFAULT_SCOPE_DEPTH_LIMIT = 100;
    public static final boolean DEFAULT_LOG_INJECTION_ENABLED = false;
    public static final String DEFAULT_EXPERIMENTAL_LOG_CAPTURE_THRESHOLD = null;
    public static final boolean DEFAULT_KAFKA_CLIENT_PROPAGATION_ENABLED = true;
    private static final String DEFAULT_TRACE_ANNOTATIONS = null;
    private static final boolean DEFAULT_TRACE_EXECUTORS_ALL = false;
    private static final String DEFAULT_TRACE_EXECUTORS = "";
    private static final String DEFAULT_TRACE_METHODS = null;
    private static final String DEFAULT_TRACE_ANNOTATED_METHODS_EXCLUDE = null;
    public static final String SQL_NORMALIZER_ENABLED = "sql.normalizer.enabled";
    public static final boolean DEFAULT_SQL_NORMALIZER_ENABLED = true;
    private final String exporterJar;
    private final String exporter;
    private final List<String> propagators;
    private final boolean traceEnabled;
    private final boolean integrationsEnabled;
    private final List<String> excludedClasses;
    private final boolean httpServerTagQueryString;
    private final boolean httpClientTagQueryString;
    private final Integer scopeDepthLimit;
    private final boolean runtimeContextFieldInjection;
    private final boolean logInjectionEnabled;
    private final String experimentalLogCaptureThreshold;
    private final String traceAnnotations;
    private final String traceMethods;
    private final String traceAnnotatedMethodsExclude;
    private final boolean traceExecutorsAll;
    private final List<String> traceExecutors;
    private final boolean sqlNormalizerEnabled;
    private final boolean kafkaClientPropagationEnabled;
    private final Map<String, String> endpointPeerServiceMapping;
    private static Properties propertiesFromConfigFile;
    private static final Config INSTANCE;

    Config() {
        propertiesFromConfigFile = Config.loadConfigurationFile();
        this.propagators = Config.getListSettingFromEnvironment(PROPAGATORS, null);
        this.exporterJar = Config.getSettingFromEnvironment(EXPORTER_JAR, null);
        this.exporter = Config.getSettingFromEnvironment(EXPORTER, "otlp");
        this.traceEnabled = Config.getBooleanSettingFromEnvironment(TRACE_ENABLED, true);
        this.integrationsEnabled = Config.getBooleanSettingFromEnvironment(INTEGRATIONS_ENABLED, true);
        this.excludedClasses = Config.getListSettingFromEnvironment(TRACE_CLASSES_EXCLUDE, null);
        this.httpServerTagQueryString = Config.getBooleanSettingFromEnvironment(HTTP_SERVER_TAG_QUERY_STRING, false);
        this.httpClientTagQueryString = Config.getBooleanSettingFromEnvironment(HTTP_CLIENT_TAG_QUERY_STRING, false);
        this.scopeDepthLimit = Config.getIntegerSettingFromEnvironment(SCOPE_DEPTH_LIMIT, 100);
        this.runtimeContextFieldInjection = Config.getBooleanSettingFromEnvironment(RUNTIME_CONTEXT_FIELD_INJECTION, true);
        this.logInjectionEnabled = Config.getBooleanSettingFromEnvironment(LOG_INJECTION_ENABLED, false);
        this.experimentalLogCaptureThreshold = Config.toUpper(Config.getSettingFromEnvironment(EXPERIMENTAL_LOG_CAPTURE_THRESHOLD, DEFAULT_EXPERIMENTAL_LOG_CAPTURE_THRESHOLD));
        this.traceAnnotations = Config.getSettingFromEnvironment(TRACE_ANNOTATIONS, DEFAULT_TRACE_ANNOTATIONS);
        this.traceMethods = Config.getSettingFromEnvironment(TRACE_METHODS, DEFAULT_TRACE_METHODS);
        this.traceAnnotatedMethodsExclude = Config.getSettingFromEnvironment(TRACE_ANNOTATED_METHODS_EXCLUDE, DEFAULT_TRACE_ANNOTATED_METHODS_EXCLUDE);
        this.traceExecutorsAll = Config.getBooleanSettingFromEnvironment(TRACE_EXECUTORS_ALL, false);
        this.traceExecutors = Config.getListSettingFromEnvironment(TRACE_EXECUTORS, DEFAULT_TRACE_EXECUTORS);
        this.sqlNormalizerEnabled = Config.getBooleanSettingFromEnvironment(SQL_NORMALIZER_ENABLED, true);
        this.kafkaClientPropagationEnabled = Config.getBooleanSettingFromEnvironment(KAFKA_CLIENT_PROPAGATION_ENABLED, true);
        this.endpointPeerServiceMapping = Config.getMapSettingFromEnvironment(ENDPOINT_PEER_SERVICE_MAPPING);
        log.debug("New instance: {}", (Object)this);
    }

    private Config(Properties properties, Config parent) {
        this.exporterJar = properties.getProperty(EXPORTER_JAR, parent.exporterJar);
        this.exporter = properties.getProperty(EXPORTER, parent.exporter);
        this.propagators = Config.getPropertyListValue(properties, PROPAGATORS, parent.propagators);
        this.traceEnabled = Config.getPropertyBooleanValue(properties, TRACE_ENABLED, parent.traceEnabled);
        this.integrationsEnabled = Config.getPropertyBooleanValue(properties, INTEGRATIONS_ENABLED, parent.integrationsEnabled);
        this.excludedClasses = Config.getPropertyListValue(properties, TRACE_CLASSES_EXCLUDE, parent.excludedClasses);
        this.httpServerTagQueryString = Config.getPropertyBooleanValue(properties, HTTP_SERVER_TAG_QUERY_STRING, parent.httpServerTagQueryString);
        this.httpClientTagQueryString = Config.getPropertyBooleanValue(properties, HTTP_CLIENT_TAG_QUERY_STRING, parent.httpClientTagQueryString);
        this.scopeDepthLimit = Config.getPropertyIntegerValue(properties, SCOPE_DEPTH_LIMIT, parent.scopeDepthLimit);
        this.runtimeContextFieldInjection = Config.getPropertyBooleanValue(properties, RUNTIME_CONTEXT_FIELD_INJECTION, parent.runtimeContextFieldInjection);
        this.logInjectionEnabled = Config.getPropertyBooleanValue(properties, LOG_INJECTION_ENABLED, parent.logInjectionEnabled);
        this.experimentalLogCaptureThreshold = Config.toUpper(properties.getProperty(EXPERIMENTAL_LOG_CAPTURE_THRESHOLD, parent.experimentalLogCaptureThreshold));
        this.traceAnnotations = properties.getProperty(TRACE_ANNOTATIONS, parent.traceAnnotations);
        this.traceMethods = properties.getProperty(TRACE_METHODS, parent.traceMethods);
        this.traceAnnotatedMethodsExclude = properties.getProperty(TRACE_ANNOTATED_METHODS_EXCLUDE, parent.traceAnnotatedMethodsExclude);
        this.traceExecutorsAll = Config.getPropertyBooleanValue(properties, TRACE_EXECUTORS_ALL, parent.traceExecutorsAll);
        this.traceExecutors = Config.getPropertyListValue(properties, TRACE_EXECUTORS, parent.traceExecutors);
        this.sqlNormalizerEnabled = Config.getPropertyBooleanValue(properties, SQL_NORMALIZER_ENABLED, parent.sqlNormalizerEnabled);
        this.kafkaClientPropagationEnabled = Config.getPropertyBooleanValue(properties, KAFKA_CLIENT_PROPAGATION_ENABLED, parent.kafkaClientPropagationEnabled);
        this.endpointPeerServiceMapping = Config.getPropertyMapValue(properties, ENDPOINT_PEER_SERVICE_MAPPING, parent.endpointPeerServiceMapping);
        log.debug("New instance: {}", (Object)this);
    }

    public boolean isIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : integrationNames) {
            boolean configEnabled = Config.getBooleanSettingFromEnvironment("integration." + name + ".enabled", defaultEnabled);
            if (defaultEnabled) {
                anyEnabled &= configEnabled;
                continue;
            }
            anyEnabled |= configEnabled;
        }
        return anyEnabled;
    }

    public static String getSettingFromEnvironment(String name, String defaultValue) {
        String systemPropertyName = Config.propertyNameToSystemPropertyName(name);
        String value = System.getProperties().getProperty(systemPropertyName);
        if (null != value) {
            return value;
        }
        value = System.getenv(Config.propertyNameToEnvironmentVariableName(name));
        if (null != value) {
            return value;
        }
        value = propertiesFromConfigFile.getProperty(systemPropertyName);
        if (null != value) {
            return value;
        }
        return defaultValue;
    }

    private static List<String> getListSettingFromEnvironment(String name, String defaultValue) {
        return Config.parseList(Config.getSettingFromEnvironment(name, defaultValue));
    }

    private static Map<String, String> getMapSettingFromEnvironment(String name) {
        return Config.parseMap(Config.getSettingFromEnvironment(name, null));
    }

    private static Boolean getBooleanSettingFromEnvironment(String name, Boolean defaultValue) {
        return Config.getSettingFromEnvironmentWithLog(name, Boolean.class, defaultValue);
    }

    private static Integer getIntegerSettingFromEnvironment(String name, Integer defaultValue) {
        return Config.getSettingFromEnvironmentWithLog(name, Integer.class, defaultValue);
    }

    private static <T> T getSettingFromEnvironmentWithLog(String name, Class<T> tClass, T defaultValue) {
        try {
            return Config.valueOf(Config.getSettingFromEnvironment(name, null), tClass, defaultValue);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid configuration for " + name, (Throwable)e);
            return defaultValue;
        }
    }

    private static String propertyNameToEnvironmentVariableName(String setting) {
        return ENV_REPLACEMENT.matcher(Config.propertyNameToSystemPropertyName(setting).toUpperCase()).replaceAll("_");
    }

    private static String propertyNameToSystemPropertyName(String setting) {
        return PREFIX + setting;
    }

    private static <T> T valueOf(String value, Class<T> tClass, T defaultValue) {
        if (value == null || value.trim().isEmpty()) {
            return defaultValue;
        }
        try {
            return (T)PUBLIC_LOOKUP.findStatic(tClass, "valueOf", MethodType.methodType(tClass, String.class)).invoke(value);
        }
        catch (NumberFormatException e) {
            throw e;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            log.debug("Can't invoke or access 'valueOf': ", (Throwable)e);
            throw new NumberFormatException(e.toString());
        }
        catch (Throwable e) {
            log.debug("Can't parse: ", e);
            throw new NumberFormatException(e.toString());
        }
    }

    private static List<String> getPropertyListValue(Properties properties, String name, List<String> defaultValue) {
        String value = properties.getProperty(name);
        return value == null || value.trim().isEmpty() ? defaultValue : Config.parseList(value);
    }

    private static Map<String, String> getPropertyMapValue(Properties properties, String name, Map<String, String> defaultValue) {
        String value = properties.getProperty(name);
        return value == null || value.trim().isEmpty() ? defaultValue : Config.parseMap(value);
    }

    private static Boolean getPropertyBooleanValue(Properties properties, String name, Boolean defaultValue) {
        return Config.valueOf(properties.getProperty(name), Boolean.class, defaultValue);
    }

    private static Integer getPropertyIntegerValue(Properties properties, String name, Integer defaultValue) {
        return Config.valueOf(properties.getProperty(name), Integer.class, defaultValue);
    }

    private static List<String> parseList(String str) {
        if (str == null || str.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String[] tokens = str.split(",", -1);
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return Collections.unmodifiableList(Arrays.asList(tokens));
    }

    private static Map<String, String> parseMap(String str) {
        if (str == null || str.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String token : str.split(",", -1)) {
            String[] parts = (token = token.trim()).split("=", -1);
            if (parts.length != 2) {
                log.warn("Invalid map config part, should be formatted key1=value1,key2=value2: {}", (Object)str);
                return Collections.emptyMap();
            }
            result.put(parts[0], parts[1]);
        }
        return Collections.unmodifiableMap(result);
    }

    private static Properties loadConfigurationFile() {
        Properties properties = new Properties();
        String configurationFilePath = System.getProperty(Config.propertyNameToSystemPropertyName(CONFIGURATION_FILE));
        if (null == configurationFilePath) {
            configurationFilePath = System.getenv(Config.propertyNameToEnvironmentVariableName(CONFIGURATION_FILE));
        }
        if (null == configurationFilePath) {
            return properties;
        }
        File configurationFile = new File(configurationFilePath = configurationFilePath.replaceFirst("^~", System.getProperty("user.home")));
        if (!configurationFile.exists()) {
            log.error("Configuration file '{}' not found.", (Object)configurationFilePath);
            return properties;
        }
        try (FileReader fileReader = new FileReader(configurationFile);){
            properties.load(fileReader);
        }
        catch (FileNotFoundException fnf) {
            log.error("Configuration file '{}' not found.", (Object)configurationFilePath);
        }
        catch (IOException ioe) {
            log.error("Configuration file '{}' cannot be accessed or correctly parsed.", (Object)configurationFilePath);
        }
        return properties;
    }

    private static String toUpper(String str) {
        return str == null ? null : str.toUpperCase(Locale.ENGLISH);
    }

    public static Config get() {
        return INSTANCE;
    }

    public static Config get(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return INSTANCE;
        }
        return new Config(properties, INSTANCE);
    }

    public String getExporterJar() {
        return this.exporterJar;
    }

    public String getExporter() {
        return this.exporter;
    }

    public List<String> getPropagators() {
        return this.propagators;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public boolean isIntegrationsEnabled() {
        return this.integrationsEnabled;
    }

    public List<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    public boolean isHttpServerTagQueryString() {
        return this.httpServerTagQueryString;
    }

    public boolean isHttpClientTagQueryString() {
        return this.httpClientTagQueryString;
    }

    public Integer getScopeDepthLimit() {
        return this.scopeDepthLimit;
    }

    public boolean isRuntimeContextFieldInjection() {
        return this.runtimeContextFieldInjection;
    }

    public boolean isLogInjectionEnabled() {
        return this.logInjectionEnabled;
    }

    public String getExperimentalLogCaptureThreshold() {
        return this.experimentalLogCaptureThreshold;
    }

    public String getTraceAnnotations() {
        return this.traceAnnotations;
    }

    public String getTraceMethods() {
        return this.traceMethods;
    }

    public String getTraceAnnotatedMethodsExclude() {
        return this.traceAnnotatedMethodsExclude;
    }

    public boolean isTraceExecutorsAll() {
        return this.traceExecutorsAll;
    }

    public List<String> getTraceExecutors() {
        return this.traceExecutors;
    }

    public boolean isSqlNormalizerEnabled() {
        return this.sqlNormalizerEnabled;
    }

    public boolean isKafkaClientPropagationEnabled() {
        return this.kafkaClientPropagationEnabled;
    }

    public Map<String, String> getEndpointPeerServiceMapping() {
        return this.endpointPeerServiceMapping;
    }

    public String toString() {
        return "Config{exporterJar='" + this.exporterJar + '\'' + ", exporter='" + this.exporter + '\'' + ", propagators=" + this.propagators + ", traceEnabled=" + this.traceEnabled + ", integrationsEnabled=" + this.integrationsEnabled + ", excludedClasses=" + this.excludedClasses + ", httpServerTagQueryString=" + this.httpServerTagQueryString + ", httpClientTagQueryString=" + this.httpClientTagQueryString + ", scopeDepthLimit=" + this.scopeDepthLimit + ", runtimeContextFieldInjection=" + this.runtimeContextFieldInjection + ", logInjectionEnabled=" + this.logInjectionEnabled + ", experimentalLogCaptureThreshold='" + this.experimentalLogCaptureThreshold + '\'' + ", traceAnnotations='" + this.traceAnnotations + '\'' + ", traceMethods='" + this.traceMethods + '\'' + ", traceAnnotatedMethodsExclude='" + this.traceAnnotatedMethodsExclude + '\'' + ", traceExecutorsAll=" + this.traceExecutorsAll + ", traceExecutors=" + this.traceExecutors + ", sqlNormalizerEnabled=" + this.sqlNormalizerEnabled + ", kafkaClientPropagationEnabled=" + this.kafkaClientPropagationEnabled + ", endpointPeerServiceMapping=" + this.endpointPeerServiceMapping + '}';
    }

    static {
        INSTANCE = new Config();
    }
}

