/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.bootstrap.instrumentation.java.concurrent;

import io.grpc.Context;
import io.opentelemetry.auto.bootstrap.ContextStore;
import io.opentelemetry.auto.bootstrap.WeakMap;
import io.opentelemetry.auto.bootstrap.instrumentation.java.concurrent.AdviceUtils;
import io.opentelemetry.auto.bootstrap.instrumentation.java.concurrent.CallableWrapper;
import io.opentelemetry.auto.bootstrap.instrumentation.java.concurrent.RunnableWrapper;
import io.opentelemetry.auto.bootstrap.instrumentation.java.concurrent.State;
import io.opentelemetry.trace.Span;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorInstrumentationUtils {
    public static final Context.Key<List<StackTraceElement[]>> THREAD_PROPAGATION_LOCATIONS = Context.key((String)"thread-propagation-locations");
    private static final boolean THREAD_PROPAGATION_DEBUGGER = Boolean.getBoolean("otel.threadPropagationDebugger");
    private static final Logger log = LoggerFactory.getLogger(ExecutorInstrumentationUtils.class);
    private static final WeakMap<Executor, Boolean> EXECUTORS_DISABLED_FOR_WRAPPED_TASKS = WeakMap.Provider.newWeakMap();

    public static boolean shouldAttachStateToTask(Object task, Executor executor) {
        if (task == null) {
            return false;
        }
        Span span = AdviceUtils.TRACER.getCurrentSpan();
        Class<?> taskClass = task.getClass();
        Class<?> enclosingClass = taskClass.getEnclosingClass();
        return span.getContext().isValid() && !ExecutorInstrumentationUtils.isExecutorDisabledForThisTask(executor, task) && !taskClass.getName().equals("org.apache.tomcat.util.net.NioEndpoint$SocketProcessor") && (enclosingClass == null || !enclosingClass.getName().equals("io.netty.util.concurrent.SingleThreadEventExecutor"));
    }

    public static <T> State setupState(ContextStore<T, State> contextStore, T task, Context context) {
        State state = contextStore.putIfAbsent(task, State.FACTORY);
        if (THREAD_PROPAGATION_DEBUGGER) {
            CopyOnWriteArrayList<StackTraceElement[]> location = (CopyOnWriteArrayList<StackTraceElement[]>)THREAD_PROPAGATION_LOCATIONS.get(context);
            if (location == null) {
                location = new CopyOnWriteArrayList<StackTraceElement[]>();
                context = context.withValue(THREAD_PROPAGATION_LOCATIONS, location);
            }
            location.add(0, new Exception().getStackTrace());
        }
        state.setParentSpan(context);
        return state;
    }

    public static void cleanUpOnMethodExit(State state, Throwable throwable) {
        if (null != state && null != throwable) {
            state.clearParentContext();
        }
    }

    public static void disableExecutorForWrappedTasks(Executor executor) {
        log.debug("Disabling Executor tracing for wrapped tasks for instance {}", (Object)executor);
        EXECUTORS_DISABLED_FOR_WRAPPED_TASKS.put(executor, true);
    }

    public static boolean isExecutorDisabledForThisTask(Executor executor, Object task) {
        return (task instanceof RunnableWrapper || task instanceof CallableWrapper) && EXECUTORS_DISABLED_FOR_WRAPPED_TASKS.containsKey(executor);
    }
}

