/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.bootstrap.instrumentation.decorator;

import io.grpc.Context;
import io.opentelemetry.OpenTelemetry;
import io.opentelemetry.auto.bootstrap.instrumentation.decorator.BaseTracer;
import io.opentelemetry.auto.bootstrap.instrumentation.decorator.HttpStatusConverter;
import io.opentelemetry.auto.config.Config;
import io.opentelemetry.context.ContextUtils;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.trace.EndSpanOptions;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.Tracer;
import io.opentelemetry.trace.TracingContextUtils;
import io.opentelemetry.trace.attributes.SemanticAttributes;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpServerTracer<REQUEST, RESPONSE, CONNECTION, STORAGE>
extends BaseTracer {
    private static final Logger log = LoggerFactory.getLogger(HttpServerTracer.class);
    public static final String CONTEXT_ATTRIBUTE = "io.opentelemetry.instrumentation.context";
    protected static final String USER_AGENT = "User-Agent";

    public HttpServerTracer() {
    }

    public HttpServerTracer(Tracer tracer) {
        super(tracer);
    }

    public Span startSpan(REQUEST request, CONNECTION connection, Method origin) {
        String spanName = this.spanNameForMethod(origin);
        return this.startSpan(request, connection, spanName);
    }

    public Span startSpan(REQUEST request, CONNECTION connection, String spanName) {
        return this.startSpan(request, connection, spanName, -1L);
    }

    public Span startSpan(REQUEST request, CONNECTION connection, String spanName, long startTimestamp) {
        Span.Builder builder = this.tracer.spanBuilder(spanName).setSpanKind(Span.Kind.SERVER).setParent(this.extract(request, this.getGetter()));
        if (startTimestamp >= 0L) {
            builder.setStartTimestamp(startTimestamp);
        }
        Span span = builder.startSpan();
        this.onConnection(span, connection);
        this.onRequest(span, request);
        this.onConnectionAndRequest(span, connection, request);
        return span;
    }

    public Scope startScope(Span span, STORAGE storage) {
        Context newContext = TracingContextUtils.withSpan((Span)span, (Context)Context.current().withValue(CONTEXT_SERVER_SPAN_KEY, (Object)span));
        this.attachServerContext(newContext, storage);
        return ContextUtils.withScopedContext((Context)newContext);
    }

    public void end(Span span, RESPONSE response) {
        this.end(span, response, -1L);
    }

    public void end(Span span, RESPONSE response, long timestamp) {
        HttpServerTracer.setStatus(span, this.responseStatus(response));
        HttpServerTracer.endSpan(span, timestamp);
    }

    @Override
    public void endExceptionally(Span span, Throwable throwable) {
        this.endExceptionally(span, throwable, null);
    }

    public void endExceptionally(Span span, Throwable throwable, RESPONSE response) {
        this.endExceptionally(span, throwable, response, -1L);
    }

    public void endExceptionally(Span span, Throwable throwable, RESPONSE response, long timestamp) {
        this.onError(span, this.unwrapThrowable(throwable));
        if (response == null) {
            HttpServerTracer.setStatus(span, 500);
        } else {
            HttpServerTracer.setStatus(span, this.responseStatus(response));
        }
        HttpServerTracer.endSpan(span, timestamp);
    }

    public Span getServerSpan(STORAGE storage) {
        Context attachedContext = this.getServerContext(storage);
        return attachedContext == null ? null : (Span)CONTEXT_SERVER_SPAN_KEY.get(attachedContext);
    }

    public abstract Context getServerContext(STORAGE var1);

    protected void onConnection(Span span, CONNECTION connection) {
        SemanticAttributes.NET_PEER_IP.set(span, this.peerHostIP(connection));
        Integer port = this.peerPort(connection);
        if (port != null && port > 0) {
            SemanticAttributes.NET_PEER_PORT.set(span, (long)port.intValue());
        }
    }

    protected void onRequest(Span span, REQUEST request) {
        SemanticAttributes.HTTP_METHOD.set(span, this.method(request));
        String userAgent = this.requestHeader(request, USER_AGENT);
        if (userAgent != null) {
            SemanticAttributes.HTTP_USER_AGENT.set(span, userAgent);
        }
        try {
            URI url = this.url(request);
            if (url != null) {
                String fragment;
                String path;
                StringBuilder urlBuilder = new StringBuilder();
                if (url.getScheme() != null) {
                    urlBuilder.append(url.getScheme());
                    urlBuilder.append("://");
                }
                if (url.getHost() != null) {
                    urlBuilder.append(url.getHost());
                    if (url.getPort() > 0 && url.getPort() != 80 && url.getPort() != 443) {
                        urlBuilder.append(":");
                        urlBuilder.append(url.getPort());
                    }
                }
                if ((path = url.getPath()).isEmpty()) {
                    urlBuilder.append("/");
                } else {
                    urlBuilder.append(path);
                }
                String query = url.getQuery();
                if (query != null) {
                    urlBuilder.append("?").append(query);
                }
                if ((fragment = url.getFragment()) != null) {
                    urlBuilder.append("#").append(fragment);
                }
                span.setAttribute(SemanticAttributes.HTTP_URL.key(), urlBuilder.toString());
                if (Config.get().isHttpServerTagQueryString()) {
                    span.setAttribute("http.query.string", url.getQuery());
                    span.setAttribute("http.fragment.string", url.getFragment());
                }
            }
        }
        catch (Exception e) {
            log.debug("Error tagging url", (Throwable)e);
        }
    }

    protected void onConnectionAndRequest(Span span, CONNECTION connection, REQUEST request) {
        String flavor = this.flavor(connection, request);
        if (flavor != null) {
            SemanticAttributes.HTTP_FLAVOR.set(span, flavor);
        }
        SemanticAttributes.HTTP_CLIENT_IP.set(span, this.clientIP(connection, request));
    }

    protected String clientIP(CONNECTION connection, REQUEST request) {
        String forwarded = this.requestHeader(request, "Forwarded");
        if (forwarded != null && (forwarded = HttpServerTracer.extractForwardedFor(forwarded)) != null) {
            return forwarded;
        }
        forwarded = this.requestHeader(request, "X-Forwarded-For");
        if (forwarded != null) {
            int endIndex = forwarded.indexOf(44);
            if (endIndex > 0) {
                forwarded = forwarded.substring(0, endIndex);
            }
            if (!forwarded.isEmpty()) {
                return forwarded;
            }
        }
        return this.peerHostIP(connection);
    }

    static String extractForwardedFor(String forwarded) {
        int start = forwarded.toLowerCase().indexOf("for=");
        if (start < 0) {
            return null;
        }
        if ((start += 4) >= forwarded.length() - 1) {
            return null;
        }
        for (int i = start; i < forwarded.length() - 1; ++i) {
            char c = forwarded.charAt(i);
            if (c != ',' && c != ';') continue;
            if (i == start) {
                return null;
            }
            return forwarded.substring(start, i);
        }
        return forwarded.substring(start);
    }

    private <C> SpanContext extract(C carrier, HttpTextFormat.Getter<C> getter) {
        Context context = OpenTelemetry.getPropagators().getHttpTextFormat().extract(Context.ROOT, carrier, getter);
        Span span = TracingContextUtils.getSpan((Context)context);
        return span.getContext();
    }

    private static void setStatus(Span span, int status) {
        SemanticAttributes.HTTP_STATUS_CODE.set(span, (long)status);
        span.setStatus(HttpStatusConverter.statusFromHttpStatus(status));
    }

    private static void endSpan(Span span, long timestamp) {
        if (timestamp >= 0L) {
            span.end(EndSpanOptions.builder().setEndTimestamp(timestamp).build());
        } else {
            span.end();
        }
    }

    protected abstract Integer peerPort(CONNECTION var1);

    protected abstract String peerHostIP(CONNECTION var1);

    protected abstract String flavor(CONNECTION var1, REQUEST var2);

    protected abstract HttpTextFormat.Getter<REQUEST> getGetter();

    protected abstract URI url(REQUEST var1) throws URISyntaxException;

    protected abstract String method(REQUEST var1);

    protected abstract String requestHeader(REQUEST var1, String var2);

    protected abstract int responseStatus(RESPONSE var1);

    protected abstract void attachServerContext(Context var1, STORAGE var2);
}

