/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.bootstrap.instrumentation.decorator;

import io.grpc.Context;
import io.opentelemetry.OpenTelemetry;
import io.opentelemetry.auto.bootstrap.instrumentation.decorator.BaseTracer;
import io.opentelemetry.context.ContextUtils;
import io.opentelemetry.context.Scope;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Status;
import io.opentelemetry.trace.Tracer;
import io.opentelemetry.trace.TracingContextUtils;
import io.opentelemetry.trace.attributes.SemanticAttributes;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutionException;

public abstract class DatabaseClientTracer<CONNECTION, QUERY>
extends BaseTracer {
    private static final Context.Key<Span> CONTEXT_CLIENT_SPAN_KEY = Context.key((String)"opentelemetry-trace-client-span-key");
    private static final String DB_QUERY = "DB Query";
    protected final Tracer tracer = OpenTelemetry.getTracerProvider().get(this.getInstrumentationName(), this.getVersion());

    public Span startSpan(CONNECTION connection, QUERY query) {
        String normalizedQuery = this.normalizeQuery(query);
        Span span = this.tracer.spanBuilder(this.spanName(normalizedQuery)).setSpanKind(Span.Kind.CLIENT).setAttribute(SemanticAttributes.DB_SYSTEM.key(), this.dbSystem(connection)).startSpan();
        if (connection != null) {
            this.onConnection(span, connection);
            this.onPeerConnection(span, connection);
        }
        this.onStatement(span, normalizedQuery);
        return span;
    }

    public Scope startScope(Span span) {
        Context clientSpanContext = Context.current().withValue(CONTEXT_CLIENT_SPAN_KEY, (Object)span);
        Context newContext = TracingContextUtils.withSpan((Span)span, (Context)clientSpanContext);
        return ContextUtils.withScopedContext((Context)newContext);
    }

    @Override
    public Span getCurrentSpan() {
        return this.tracer.getCurrentSpan();
    }

    public Span getClientSpan() {
        Context context = Context.current();
        return (Span)CONTEXT_CLIENT_SPAN_KEY.get(context);
    }

    @Override
    protected String getInstrumentationName() {
        return null;
    }

    @Override
    public void end(Span span) {
        span.end();
    }

    @Override
    public void endExceptionally(Span span, Throwable throwable) {
        this.onError(span, throwable);
        this.end(span);
    }

    protected Span onConnection(Span span, CONNECTION connection) {
        span.setAttribute(SemanticAttributes.DB_USER.key(), this.dbUser(connection));
        span.setAttribute(SemanticAttributes.DB_NAME.key(), this.dbName(connection));
        span.setAttribute(SemanticAttributes.DB_CONNECTION_STRING.key(), this.dbConnectionString(connection));
        return span;
    }

    @Override
    protected void onError(Span span, Throwable throwable) {
        if (throwable != null) {
            span.setStatus(Status.UNKNOWN);
            this.addThrowable(span, throwable instanceof ExecutionException ? throwable.getCause() : throwable);
        }
    }

    protected void onPeerConnection(Span span, CONNECTION connection) {
        this.onPeerConnection(span, this.peerAddress(connection));
    }

    protected void onPeerConnection(Span span, InetSocketAddress remoteConnection) {
        if (remoteConnection != null) {
            this.onPeerConnection(span, remoteConnection.getAddress());
            span.setAttribute(SemanticAttributes.NET_PEER_PORT.key(), (long)remoteConnection.getPort());
        }
    }

    protected void onPeerConnection(Span span, InetAddress remoteAddress) {
        if (remoteAddress != null) {
            DatabaseClientTracer.setPeer(span, remoteAddress.getHostName(), remoteAddress.getHostAddress());
        }
    }

    protected void onStatement(Span span, String statement) {
        span.setAttribute(SemanticAttributes.DB_STATEMENT.key(), statement);
    }

    protected String spanName(String query) {
        return query == null ? DB_QUERY : query;
    }

    protected abstract String normalizeQuery(QUERY var1);

    protected abstract String dbSystem(CONNECTION var1);

    protected abstract String dbUser(CONNECTION var1);

    protected abstract String dbName(CONNECTION var1);

    protected String dbConnectionString(CONNECTION connection) {
        return null;
    }

    protected abstract InetSocketAddress peerAddress(CONNECTION var1);
}

