/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.bootstrap.instrumentation.decorator;

import io.grpc.Context;
import io.opentelemetry.auto.bootstrap.instrumentation.decorator.BaseDecorator;
import io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Tracer;
import io.opentelemetry.trace.TracingContextUtils;

public abstract class ClientDecorator
extends BaseDecorator {
    static final Context.Key<Span> CONTEXT_CLIENT_SPAN_KEY = Context.key((String)"opentelemetry-trace-auto-client-span-key");

    public static Context currentContextWith(Span clientSpan) {
        Context context = Context.current();
        if (clientSpan.getContext().isValid()) {
            context = context.withValue(CONTEXT_CLIENT_SPAN_KEY, (Object)clientSpan);
        }
        return TracingContextUtils.withSpan((Span)clientSpan, (Context)context);
    }

    public static Span getOrCreateSpan(String name, Tracer tracer) {
        Context context = Context.current();
        Span clientSpan = (Span)CONTEXT_CLIENT_SPAN_KEY.get(context);
        if (clientSpan != null) {
            return DefaultSpan.getInvalid();
        }
        Span current = TracingContextUtils.getSpan((Context)context);
        return tracer.spanBuilder(name).setSpanKind(Span.Kind.CLIENT).setParent(current).startSpan();
    }

    @Override
    public Span afterStart(Span span) {
        assert (span != null);
        return super.afterStart(span);
    }
}

