/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.bootstrap.instrumentation.decorator;

import io.grpc.Context;
import io.opentelemetry.OpenTelemetry;
import io.opentelemetry.auto.config.Config;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.Status;
import io.opentelemetry.trace.TracingContextUtils;
import io.opentelemetry.trace.attributes.SemanticAttributes;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;

public abstract class BaseDecorator {
    private static final ClassValue<SpanNames> SPAN_NAMES = new ClassValue<SpanNames>(){

        @Override
        protected SpanNames computeValue(Class<?> type) {
            return new SpanNames(BaseDecorator.getClassName(type));
        }
    };

    protected BaseDecorator() {
    }

    public Span afterStart(Span span) {
        assert (span != null);
        return span;
    }

    public Span beforeFinish(Span span) {
        assert (span != null);
        return span;
    }

    public Span onError(Span span, Throwable throwable) {
        assert (span != null);
        if (throwable != null) {
            this.onComplete(span, Status.UNKNOWN, throwable);
        }
        return span;
    }

    public Span onComplete(Span span, Status status, Throwable throwable) {
        assert (span != null);
        span.setStatus(status);
        if (throwable != null) {
            BaseDecorator.addThrowable(span, throwable instanceof ExecutionException ? throwable.getCause() : throwable);
        }
        return span;
    }

    public Span onPeerConnection(Span span, InetSocketAddress remoteConnection) {
        assert (span != null);
        if (remoteConnection != null) {
            InetAddress remoteAddress = remoteConnection.getAddress();
            if (remoteAddress != null) {
                this.onPeerConnection(span, remoteAddress);
            } else {
                BaseDecorator.setPeer(span, remoteConnection.getHostString(), null);
            }
            span.setAttribute(SemanticAttributes.NET_PEER_PORT.key(), (long)remoteConnection.getPort());
        }
        return span;
    }

    public Span onPeerConnection(Span span, InetAddress remoteAddress) {
        assert (span != null);
        BaseDecorator.setPeer(span, remoteAddress.getHostName(), remoteAddress.getHostAddress());
        return span;
    }

    public static void setPeer(Span span, String peerName, String peerIp) {
        String peerService;
        assert (span != null);
        if (peerName != null && !peerName.equals(peerIp)) {
            SemanticAttributes.NET_PEER_NAME.set(span, peerName);
        }
        if (peerIp != null) {
            SemanticAttributes.NET_PEER_IP.set(span, peerIp);
        }
        if ((peerService = BaseDecorator.mapToPeer(peerName)) == null) {
            peerService = BaseDecorator.mapToPeer(peerIp);
        }
        if (peerService != null) {
            SemanticAttributes.PEER_SERVICE.set(span, peerService);
        }
    }

    public static void addThrowable(Span span, Throwable throwable) {
        span.recordException(throwable);
    }

    public String spanNameForMethod(Method method) {
        return this.spanNameForMethod(method.getDeclaringClass(), method);
    }

    public String spanNameForMethod(Class<?> clazz, Method method) {
        return this.spanNameForMethod(clazz, null == method ? null : method.getName());
    }

    public String spanNameForMethod(Class<?> clazz, String methodName) {
        SpanNames cn = SPAN_NAMES.get(clazz);
        return null == methodName ? cn.getClassName() : cn.getSpanName(methodName);
    }

    public String spanNameForClass(Class<?> clazz) {
        String simpleName = clazz.getSimpleName();
        return simpleName.isEmpty() ? SPAN_NAMES.get(clazz).getClassName() : simpleName;
    }

    private static String getClassName(Class<?> clazz) {
        String simpleName = clazz.getSimpleName();
        if (simpleName.isEmpty()) {
            String name = clazz.getName();
            int start = name.lastIndexOf(46);
            return name.substring(start + 1);
        }
        return simpleName;
    }

    public static <C> SpanContext extract(C carrier, HttpTextFormat.Getter<C> getter) {
        Context context = OpenTelemetry.getPropagators().getHttpTextFormat().extract(Context.current(), carrier, getter);
        Span span = TracingContextUtils.getSpan((Context)context);
        return span.getContext();
    }

    protected static String mapToPeer(String endpoint) {
        if (endpoint == null) {
            return null;
        }
        return Config.get().getEndpointPeerServiceMapping().get(endpoint);
    }

    private static class SpanNames {
        private final String className;
        private final ConcurrentHashMap<String, String> spanNames = new ConcurrentHashMap(1);

        private SpanNames(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public String getSpanName(String methodName) {
            String spanName = this.spanNames.get(methodName);
            if (null == spanName) {
                spanName = this.className + "." + methodName;
                this.spanNames.putIfAbsent(methodName, spanName);
            }
            return spanName;
        }
    }
}

