/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.bootstrap;

import io.opentelemetry.auto.bootstrap.instrumentation.api.Pair;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalJarURLHandler
extends URLStreamHandler {
    private static final Logger log = LoggerFactory.getLogger(InternalJarURLHandler.class);
    private static final WeakReference<Pair<String, JarEntry>> NULL = new WeakReference<Object>(null);
    private final String name;
    private final FileNotInInternalJar notFound;
    private final JarFile bootstrapJarFile;
    private WeakReference<Pair<String, JarEntry>> cache = NULL;

    InternalJarURLHandler(String internalJarFileName, URL bootstrapJarLocation) {
        this.name = internalJarFileName;
        this.notFound = new FileNotInInternalJar(internalJarFileName);
        JarFile jarFile = null;
        try {
            if (bootstrapJarLocation != null) {
                jarFile = new JarFile(new File(bootstrapJarLocation.toURI()), false);
            }
        }
        catch (IOException | URISyntaxException e) {
            log.error("Unable to read internal jar", (Throwable)e);
        }
        this.bootstrapJarFile = jarFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        String filename = url.getFile();
        if ("/".equals(filename)) {
            return new InternalJarURLConnection(url, new ByteArrayInputStream(new byte[0]));
        }
        Pair<String, JarEntry> pair = (Pair<String, JarEntry>)this.cache.get();
        if (null == pair || !filename.equals(pair.getLeft())) {
            JarEntry entry = this.bootstrapJarFile.getJarEntry(this.getResourcePath(filename));
            if (null == entry) throw this.notFound;
            pair = Pair.of(filename, entry);
            this.cache = new WeakReference<Pair<String, JarEntry>>(pair);
            return new InternalJarURLConnection(url, this.bootstrapJarFile.getInputStream(pair.getRight()));
        } else {
            this.cache = NULL;
        }
        return new InternalJarURLConnection(url, this.bootstrapJarFile.getInputStream(pair.getRight()));
    }

    private String getResourcePath(String filename) {
        boolean isClass = filename.endsWith(".class");
        int length = this.name.length() + filename.length();
        if (isClass) {
            length += 4;
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append(this.name).append(filename);
        if (isClass) {
            sb.append("data");
        }
        return sb.toString();
    }

    private static class FileNotInInternalJar
    extends IOException {
        public FileNotInInternalJar(String jarName) {
            super("class not found in " + jarName);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class InternalJarURLConnection
    extends URLConnection {
        private final InputStream inputStream;

        private InternalJarURLConnection(URL url, InputStream inputStream) {
            super(url);
            this.inputStream = inputStream;
        }

        @Override
        public void connect() {
            this.connected = true;
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public Permission getPermission() {
            return null;
        }
    }
}

