/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.bootstrap.instrumentation.decorator;

import io.grpc.Context;
import io.opentelemetry.OpenTelemetry;
import io.opentelemetry.auto.bootstrap.instrumentation.decorator.BaseTracer;
import io.opentelemetry.auto.bootstrap.instrumentation.decorator.HttpStatusConverter;
import io.opentelemetry.auto.config.Config;
import io.opentelemetry.context.ContextUtils;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.trace.EndSpanOptions;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.Tracer;
import io.opentelemetry.trace.TracingContextUtils;
import io.opentelemetry.trace.attributes.SemanticAttributes;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpServerTracer<REQUEST, CONNECTION, STORAGE>
extends BaseTracer {
    private static final Logger log = LoggerFactory.getLogger(HttpServerTracer.class);
    public static final String CONTEXT_ATTRIBUTE = "io.opentelemetry.instrumentation.context";

    public HttpServerTracer() {
    }

    public HttpServerTracer(Tracer tracer) {
        super(tracer);
    }

    public Span startSpan(REQUEST request, CONNECTION connection, Method origin) {
        String spanName = this.spanNameForMethod(origin);
        return this.startSpan(request, connection, spanName);
    }

    public Span startSpan(REQUEST request, CONNECTION connection, String spanName) {
        return this.startSpan(request, connection, spanName, -1L);
    }

    public Span startSpan(REQUEST request, CONNECTION connection, String spanName, long startTimestamp) {
        Span.Builder builder = this.tracer.spanBuilder(spanName).setSpanKind(Span.Kind.SERVER).setParent(this.extract(request, this.getGetter()));
        if (startTimestamp >= 0L) {
            builder.setStartTimestamp(startTimestamp);
        }
        Span span = builder.startSpan();
        this.onConnection(span, connection);
        this.onRequest(span, request);
        return span;
    }

    public Scope startScope(Span span, STORAGE storage) {
        Context newContext = TracingContextUtils.withSpan((Span)span, (Context)Context.current().withValue(CONTEXT_SERVER_SPAN_KEY, (Object)span));
        this.attachServerContext(newContext, storage);
        return ContextUtils.withScopedContext((Context)newContext);
    }

    public void end(Span span, int responseStatus) {
        this.end(span, responseStatus, -1L);
    }

    public void end(Span span, int responseStatus, long timestamp) {
        this.setStatus(span, responseStatus);
        if (timestamp >= 0L) {
            span.end(EndSpanOptions.builder().setEndTimestamp(timestamp).build());
        } else {
            span.end();
        }
    }

    @Override
    public void endExceptionally(Span span, Throwable throwable) {
        this.endExceptionally(span, throwable, 500);
    }

    public void endExceptionally(Span span, Throwable throwable, int responseStatus) {
        this.endExceptionally(span, throwable, responseStatus, -1L);
    }

    public void endExceptionally(Span span, Throwable throwable, int responseStatus, long timestamp) {
        if (responseStatus == 200) {
            responseStatus = 500;
        }
        this.onError(span, this.unwrapThrowable(throwable));
        this.end(span, responseStatus, timestamp);
    }

    public Span getServerSpan(STORAGE storage) {
        Context attachedContext = this.getServerContext(storage);
        return attachedContext == null ? null : (Span)CONTEXT_SERVER_SPAN_KEY.get(attachedContext);
    }

    public abstract Context getServerContext(STORAGE var1);

    protected void onConnection(Span span, CONNECTION connection) {
        SemanticAttributes.NET_PEER_IP.set(span, this.peerHostIP(connection));
        Integer port = this.peerPort(connection);
        if (port != null && port > 0) {
            SemanticAttributes.NET_PEER_PORT.set(span, (long)port.intValue());
        }
    }

    protected void onRequest(Span span, REQUEST request) {
        SemanticAttributes.HTTP_METHOD.set(span, this.method(request));
        try {
            URI url = this.url(request);
            if (url != null) {
                String fragment;
                String path;
                StringBuilder urlBuilder = new StringBuilder();
                if (url.getScheme() != null) {
                    urlBuilder.append(url.getScheme());
                    urlBuilder.append("://");
                }
                if (url.getHost() != null) {
                    urlBuilder.append(url.getHost());
                    if (url.getPort() > 0 && url.getPort() != 80 && url.getPort() != 443) {
                        urlBuilder.append(":");
                        urlBuilder.append(url.getPort());
                    }
                }
                if ((path = url.getPath()).isEmpty()) {
                    urlBuilder.append("/");
                } else {
                    urlBuilder.append(path);
                }
                String query = url.getQuery();
                if (query != null) {
                    urlBuilder.append("?").append(query);
                }
                if ((fragment = url.getFragment()) != null) {
                    urlBuilder.append("#").append(fragment);
                }
                span.setAttribute(SemanticAttributes.HTTP_URL.key(), urlBuilder.toString());
                if (Config.get().isHttpServerTagQueryString()) {
                    span.setAttribute("http.query.string", url.getQuery());
                    span.setAttribute("http.fragment.string", url.getFragment());
                }
            }
        }
        catch (Exception e) {
            log.debug("Error tagging url", (Throwable)e);
        }
    }

    private <C> SpanContext extract(C carrier, HttpTextFormat.Getter<C> getter) {
        Context context = OpenTelemetry.getPropagators().getHttpTextFormat().extract(Context.ROOT, carrier, getter);
        Span span = TracingContextUtils.getSpan((Context)context);
        return span.getContext();
    }

    private void setStatus(Span span, int status) {
        SemanticAttributes.HTTP_STATUS_CODE.set(span, (long)status);
        span.setStatus(HttpStatusConverter.statusFromHttpStatus(status));
    }

    protected abstract Integer peerPort(CONNECTION var1);

    protected abstract String peerHostIP(CONNECTION var1);

    protected abstract HttpTextFormat.Getter<REQUEST> getGetter();

    protected abstract URI url(REQUEST var1) throws URISyntaxException;

    protected abstract String method(REQUEST var1);

    protected abstract void attachServerContext(Context var1, STORAGE var2);
}

