/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.stacktrace;

import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.internal.ExtendedSpanProcessor;
import io.opentelemetry.semconv.CodeAttributes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Predicate;

public class StackTraceSpanProcessor
implements ExtendedSpanProcessor {
    private final long minSpanDurationNanos;
    private final Predicate<ReadableSpan> filterPredicate;

    public StackTraceSpanProcessor(long minSpanDurationNanos, Predicate<ReadableSpan> filterPredicate) {
        if (minSpanDurationNanos < 0L) {
            throw new IllegalArgumentException("minimal span duration must be positive or zero");
        }
        this.minSpanDurationNanos = minSpanDurationNanos;
        this.filterPredicate = filterPredicate;
    }

    public boolean isStartRequired() {
        return false;
    }

    public void onStart(Context context, ReadWriteSpan readWriteSpan) {
    }

    public boolean isOnEndingRequired() {
        return true;
    }

    public void onEnding(ReadWriteSpan span) {
        if (span.getLatencyNanos() < this.minSpanDurationNanos) {
            return;
        }
        if (span.getAttribute(CodeAttributes.CODE_STACKTRACE) != null) {
            return;
        }
        if (!this.filterPredicate.test((ReadableSpan)span)) {
            return;
        }
        span.setAttribute(CodeAttributes.CODE_STACKTRACE, (Object)StackTraceSpanProcessor.generateSpanEndStacktrace());
    }

    public boolean isEndRequired() {
        return false;
    }

    public void onEnd(ReadableSpan readableSpan) {
    }

    private static String generateSpanEndStacktrace() {
        Throwable exception = new Throwable();
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            exception.printStackTrace(printWriter);
        }
        return StackTraceSpanProcessor.removeInternalFrames(stringWriter.toString());
    }

    private static String removeInternalFrames(String stackTrace) {
        String lastInternal = "at io.opentelemetry.sdk.trace.SdkSpan.end";
        int idx = stackTrace.lastIndexOf(lastInternal);
        if (idx == -1) {
            return stackTrace;
        }
        int nextNewLine = stackTrace.indexOf(10, idx);
        if (nextNewLine == -1) {
            nextNewLine = stackTrace.length() - 1;
        }
        return stackTrace.substring(nextNewLine + 1);
    }
}

