/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.attach.core;

import io.opentelemetry.contrib.attach.core.RuntimeAttachException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

final class AgentFileProvider {
    private final String agentJarResourceName;

    AgentFileProvider(String agentJarResourceName) {
        this.agentJarResourceName = agentJarResourceName;
    }

    File getAgentFile() {
        Path tempDirPath = AgentFileProvider.createTempDir();
        Path tempAgentJarPath = this.createTempAgentJarFileIn(tempDirPath);
        AgentFileProvider.deleteTempDirOnJvmExit(tempDirPath, tempAgentJarPath);
        return tempAgentJarPath.toFile();
    }

    private static void deleteTempDirOnJvmExit(Path tempDirPath, Path tempAgentJarPath) {
        tempAgentJarPath.toFile().deleteOnExit();
        tempDirPath.toFile().deleteOnExit();
    }

    private static Path createTempDir() {
        Path tempDir;
        try {
            tempDir = Files.createTempDirectory("otel-agent", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeAttachException("Runtime attachment can't create a temp directory. Are you using a read-only file system?", e);
        }
        return tempDir;
    }

    private Path createTempAgentJarFileIn(Path tempDir) {
        Path agentJarPath = tempDir.resolve("agent.jar");
        try (InputStream jarAsInputStream = AgentFileProvider.class.getResourceAsStream(this.agentJarResourceName);){
            if (jarAsInputStream == null) {
                throw new RuntimeAttachException(this.agentJarResourceName + " resource can't be found");
            }
            Files.copy(jarAsInputStream, agentJarPath, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeAttachException("Runtime attachment can't create an agent jar file in temp directory", e);
        }
        return agentJarPath;
    }
}

