/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.storage.impl;

import com.google.auto.value.AutoValue;
import io.opentelemetry.contrib.disk.buffering.storage.impl.AutoValue_FileStorageConfiguration;
import java.util.concurrent.TimeUnit;

@AutoValue
public abstract class FileStorageConfiguration {
    public abstract long getMaxFileAgeForWriteMillis();

    public abstract long getMinFileAgeForReadMillis();

    public abstract long getMaxFileAgeForReadMillis();

    public abstract int getMaxFileSize();

    public abstract int getMaxFolderSize();

    public static FileStorageConfiguration getDefault() {
        return FileStorageConfiguration.builder().build();
    }

    public static Builder builder() {
        return new AutoValue_FileStorageConfiguration.Builder().setMaxFileSize(0x100000).setMaxFolderSize(0xA00000).setMaxFileAgeForWriteMillis(TimeUnit.SECONDS.toMillis(30L)).setMinFileAgeForReadMillis(TimeUnit.SECONDS.toMillis(33L)).setMaxFileAgeForReadMillis(TimeUnit.HOURS.toMillis(18L));
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setMaxFileAgeForWriteMillis(long var1);

        public abstract Builder setMinFileAgeForReadMillis(long var1);

        public abstract Builder setMaxFileAgeForReadMillis(long var1);

        public abstract Builder setMaxFileSize(int var1);

        public abstract Builder setMaxFolderSize(int var1);

        abstract FileStorageConfiguration autoBuild();

        public final FileStorageConfiguration build() {
            FileStorageConfiguration configuration = this.autoBuild();
            if (configuration.getMinFileAgeForReadMillis() <= configuration.getMaxFileAgeForWriteMillis()) {
                throw new IllegalArgumentException("The configured max file age for writing must be lower than the configured min file age for reading");
            }
            return configuration;
        }
    }
}

