/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.storage.files.reader;

import io.opentelemetry.contrib.disk.buffering.internal.storage.files.reader.StreamReader;
import io.opentelemetry.contrib.disk.buffering.internal.utils.ProtobufTools;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;

public final class DelimitedProtoStreamReader
implements StreamReader {
    private final InputStream inputStream;

    public DelimitedProtoStreamReader(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    @Nullable
    public byte[] readNext() throws IOException {
        int readCt;
        int itemSize = this.getNextItemSize();
        if (itemSize < 1) {
            return null;
        }
        byte[] bytes = new byte[itemSize];
        int offset = 0;
        while ((readCt = this.inputStream.read(bytes, offset, itemSize - offset)) != -1 && (offset += readCt) < itemSize) {
        }
        if (offset != itemSize) {
            return null;
        }
        return bytes;
    }

    private int getNextItemSize() {
        try {
            int firstByte = this.inputStream.read();
            if (firstByte == -1) {
                return 0;
            }
            return ProtobufTools.readRawVarint32(firstByte, this.inputStream);
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public static class Factory
    implements StreamReader.Factory {
        private static final Factory INSTANCE = new Factory();

        public static Factory getInstance() {
            return INSTANCE;
        }

        private Factory() {
        }

        @Override
        public StreamReader create(InputStream inputStream) {
            return new DelimitedProtoStreamReader(inputStream);
        }
    }
}

