/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.storage.files;

import io.opentelemetry.contrib.disk.buffering.internal.storage.files.FileOperations;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.reader.DelimitedProtoStreamReader;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.reader.StreamReader;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.utils.FileStream;
import io.opentelemetry.contrib.disk.buffering.internal.storage.util.ClockBuddy;
import io.opentelemetry.contrib.disk.buffering.storage.impl.FileStorageConfiguration;
import io.opentelemetry.sdk.common.Clock;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ReadableFile
implements FileOperations {
    @Nonnull
    private final File file;
    private final FileStream fileStream;
    private final StreamReader reader;
    private final Clock clock;
    private final long expireTimeMillis;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    public ReadableFile(File file, long createdTimeMillis, Clock clock, FileStorageConfiguration configuration) throws IOException {
        this(file, createdTimeMillis, clock, configuration, DelimitedProtoStreamReader.Factory.getInstance());
    }

    public ReadableFile(@Nonnull File file, long createdTimeMillis, Clock clock, FileStorageConfiguration configuration, StreamReader.Factory readerFactory) throws IOException {
        this.file = file;
        this.clock = clock;
        this.expireTimeMillis = createdTimeMillis + configuration.getMaxFileAgeForReadMillis();
        this.fileStream = FileStream.create(file);
        this.reader = readerFactory.create(this.fileStream);
    }

    @Nullable
    public synchronized byte[] readNext() throws IOException {
        if (this.isClosed.get()) {
            return null;
        }
        if (this.hasExpired()) {
            this.close();
            return null;
        }
        byte[] resultBytes = this.reader.readNext();
        if (resultBytes == null) {
            this.clear();
            return null;
        }
        return resultBytes;
    }

    @Override
    public synchronized boolean hasExpired() {
        return ClockBuddy.nowMillis(this.clock) >= this.expireTimeMillis;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    @Nonnull
    public File getFile() {
        return this.file;
    }

    public synchronized void clear() throws IOException {
        this.close();
        if (!this.file.delete()) {
            throw new IOException("Could not delete file: " + this.file);
        }
    }

    public synchronized void removeTopItem() throws IOException {
        this.fileStream.truncateTop();
        if (this.fileStream.size() == 0L) {
            this.clear();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed.compareAndSet(false, true)) {
            this.reader.close();
        }
    }

    public String toString() {
        return "ReadableFile{file=" + this.file + '}';
    }
}

