/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.storage;

import io.opentelemetry.contrib.disk.buffering.internal.serialization.deserializers.SignalDeserializer;
import io.opentelemetry.contrib.disk.buffering.internal.storage.Storage;
import io.opentelemetry.contrib.disk.buffering.internal.storage.responses.ReadableResult;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

final class StorageIterator<T>
implements Iterator<Collection<T>> {
    private final Storage<T> storage;
    private final SignalDeserializer<T> deserializer;
    private final Logger logger = Logger.getLogger(StorageIterator.class.getName());
    @Nullable
    @GuardedBy(value="this")
    private ReadableResult<T> currentResult;
    @GuardedBy(value="this")
    private boolean currentResultConsumed = false;

    StorageIterator(Storage<T> storage, SignalDeserializer<T> deserializer) {
        this.storage = storage;
        this.deserializer = deserializer;
    }

    @Override
    public synchronized boolean hasNext() {
        if (this.storage.isClosed()) {
            return false;
        }
        return this.findNext();
    }

    @Override
    @Nullable
    public synchronized Collection<T> next() {
        if (this.storage.isClosed()) {
            return null;
        }
        if (this.findNext()) {
            this.currentResultConsumed = true;
            return Objects.requireNonNull(this.currentResult).getContent();
        }
        return null;
    }

    @Override
    public synchronized void remove() {
        if (this.currentResult != null) {
            try {
                this.currentResult.delete();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Error deleting stored item", e);
            }
        }
    }

    private synchronized boolean findNext() {
        try {
            if (this.currentResult != null) {
                if (!this.currentResultConsumed) {
                    return true;
                }
                this.currentResult.delete();
                this.currentResult.close();
                this.currentResult = null;
            }
            this.currentResultConsumed = false;
            ReadableResult<T> result = this.storage.readNext(this.deserializer);
            if (result != null) {
                this.currentResult = result;
                return true;
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Error reading from storage", e);
        }
        return false;
    }
}

