/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.exporters;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.contrib.disk.buffering.exporters.callback.ExporterCallback;
import io.opentelemetry.contrib.disk.buffering.exporters.callback.NoopExporterCallback;
import io.opentelemetry.contrib.disk.buffering.internal.exporters.SignalStorageExporter;
import io.opentelemetry.contrib.disk.buffering.storage.SignalStorage;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.time.Duration;
import java.util.Collection;

public final class SpanToDiskExporter
implements SpanExporter {
    private final SignalStorageExporter<SpanData> storageExporter;
    private final ExporterCallback<SpanData> callback;
    private static final ExporterCallback<SpanData> DEFAULT_CALLBACK = new NoopExporterCallback<SpanData>();
    private static final Duration DEFAULT_EXPORT_TIMEOUT = Duration.ofSeconds(10L);

    private SpanToDiskExporter(SignalStorageExporter<SpanData> storageExporter, ExporterCallback<SpanData> callback) {
        this.storageExporter = storageExporter;
        this.callback = callback;
    }

    public static Builder builder(SignalStorage.Span storage) {
        return new Builder(storage);
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        return this.storageExporter.exportToStorage(spans);
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.callback.onShutdown();
        return CompletableResultCode.ofSuccess();
    }

    static /* synthetic */ ExporterCallback access$100() {
        return DEFAULT_CALLBACK;
    }

    static /* synthetic */ Duration access$200() {
        return DEFAULT_EXPORT_TIMEOUT;
    }

    public static final class Builder {
        private final SignalStorage.Span storage;
        private ExporterCallback<SpanData> callback = SpanToDiskExporter.access$100();
        private Duration writeTimeout = SpanToDiskExporter.access$200();

        private Builder(SignalStorage.Span storage) {
            this.storage = storage;
        }

        @CanIgnoreReturnValue
        public Builder setExporterCallback(ExporterCallback<SpanData> value) {
            this.callback = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setWriteTimeout(Duration value) {
            this.writeTimeout = value;
            return this;
        }

        public SpanToDiskExporter build() {
            SignalStorageExporter<SpanData> storageExporter = new SignalStorageExporter<SpanData>(this.storage, this.callback, this.writeTimeout);
            return new SpanToDiskExporter(storageExporter, this.callback);
        }
    }
}

