/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.exporters;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.contrib.disk.buffering.exporters.callback.ExporterCallback;
import io.opentelemetry.contrib.disk.buffering.exporters.callback.NoopExporterCallback;
import io.opentelemetry.contrib.disk.buffering.internal.exporters.SignalStorageExporter;
import io.opentelemetry.contrib.disk.buffering.storage.SignalStorage;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.time.Duration;
import java.util.Collection;

public final class LogRecordToDiskExporter
implements LogRecordExporter {
    private final SignalStorageExporter<LogRecordData> storageExporter;
    private final ExporterCallback<LogRecordData> callback;
    private static final ExporterCallback<LogRecordData> DEFAULT_CALLBACK = new NoopExporterCallback<LogRecordData>();
    private static final Duration DEFAULT_EXPORT_TIMEOUT = Duration.ofSeconds(10L);

    private LogRecordToDiskExporter(SignalStorageExporter<LogRecordData> storageExporter, ExporterCallback<LogRecordData> callback) {
        this.storageExporter = storageExporter;
        this.callback = callback;
    }

    public static Builder builder(SignalStorage.LogRecord storage) {
        return new Builder(storage);
    }

    public CompletableResultCode export(Collection<LogRecordData> logs) {
        return this.storageExporter.exportToStorage(logs);
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.callback.onShutdown();
        return CompletableResultCode.ofSuccess();
    }

    static /* synthetic */ ExporterCallback access$100() {
        return DEFAULT_CALLBACK;
    }

    static /* synthetic */ Duration access$200() {
        return DEFAULT_EXPORT_TIMEOUT;
    }

    public static final class Builder {
        private final SignalStorage.LogRecord storage;
        private ExporterCallback<LogRecordData> callback = LogRecordToDiskExporter.access$100();
        private Duration writeTimeout = LogRecordToDiskExporter.access$200();

        @CanIgnoreReturnValue
        public Builder setExporterCallback(ExporterCallback<LogRecordData> value) {
            this.callback = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setWriteTimeout(Duration value) {
            this.writeTimeout = value;
            return this;
        }

        public LogRecordToDiskExporter build() {
            SignalStorageExporter<LogRecordData> storageExporter = new SignalStorageExporter<LogRecordData>(this.storage, this.callback, this.writeTimeout);
            return new LogRecordToDiskExporter(storageExporter, this.callback);
        }

        private Builder(SignalStorage.LogRecord storage) {
            this.storage = storage;
        }
    }
}

