/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.storage.files.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.jetbrains.annotations.NotNull;

public class FileStream
extends InputStream {
    private final RandomAccessFile file;
    private final FileChannel channel;

    public static FileStream create(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rwd");
        FileChannel channel = randomAccessFile.getChannel();
        channel.force(false);
        return new FileStream(randomAccessFile, channel);
    }

    private FileStream(RandomAccessFile file, FileChannel channel) {
        this.file = file;
        this.channel = channel;
    }

    @Override
    public int read() throws IOException {
        return this.file.read();
    }

    @Override
    public int read(@NotNull byte[] bytes) throws IOException {
        return this.file.read(bytes);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        return this.file.read(b, off, len);
    }

    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
        this.file.close();
    }

    public void truncateTop(long size) throws IOException {
        this.file.seek(Math.min(this.size(), size));
        this.truncateTop();
    }

    public void truncateTop() throws IOException {
        long position = this.file.getFilePointer();
        if (position == 0L) {
            return;
        }
        long remainingSize = this.size() - position;
        if (remainingSize > 0L) {
            byte[] remainingBytes = new byte[(int)remainingSize];
            this.file.read(remainingBytes);
            this.file.seek(0L);
            this.channel.truncate(remainingSize);
            this.file.write(remainingBytes);
            this.file.seek(0L);
        } else {
            this.channel.truncate(0L);
        }
    }

    public long getPosition() throws IOException {
        return this.file.getFilePointer();
    }
}

