/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.storage.files;

import io.opentelemetry.contrib.disk.buffering.config.StorageConfiguration;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.FileOperations;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.reader.DelimitedProtoStreamReader;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.reader.ProcessResult;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.reader.ReadResult;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.reader.StreamReader;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.utils.FileStream;
import io.opentelemetry.contrib.disk.buffering.internal.storage.responses.ReadableResult;
import io.opentelemetry.contrib.disk.buffering.internal.storage.util.ClockBuddy;
import io.opentelemetry.sdk.common.Clock;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public final class ReadableFile
implements FileOperations {
    @NotNull
    private final File file;
    private final FileStream fileStream;
    private final StreamReader reader;
    private final Clock clock;
    private final long expireTimeMillis;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    @Nullable
    private ReadResult unconsumedResult;

    public ReadableFile(File file, long createdTimeMillis, Clock clock, StorageConfiguration configuration) throws IOException {
        this(file, createdTimeMillis, clock, configuration, DelimitedProtoStreamReader.Factory.getInstance());
    }

    public ReadableFile(@NotNull File file, long createdTimeMillis, Clock clock, StorageConfiguration configuration, StreamReader.Factory readerFactory) throws IOException {
        this.file = file;
        this.clock = clock;
        this.expireTimeMillis = createdTimeMillis + configuration.getMaxFileAgeForReadMillis();
        this.fileStream = FileStream.create(file);
        this.reader = readerFactory.create(this.fileStream);
    }

    public synchronized ReadableResult readAndProcess(Function<byte[], ProcessResult> processing) throws IOException {
        if (this.isClosed.get()) {
            return ReadableResult.FAILED;
        }
        if (this.hasExpired()) {
            this.close();
            return ReadableResult.FAILED;
        }
        ReadResult read = this.readNextItem();
        if (read == null) {
            this.cleanUp();
            return ReadableResult.FAILED;
        }
        switch (processing.apply(read.content)) {
            case SUCCEEDED: {
                this.unconsumedResult = null;
                this.fileStream.truncateTop();
                if (this.fileStream.size() == 0L) {
                    this.cleanUp();
                }
                return ReadableResult.SUCCEEDED;
            }
            case TRY_LATER: {
                this.unconsumedResult = read;
                return ReadableResult.TRY_LATER;
            }
            case CONTENT_INVALID: {
                this.cleanUp();
                return ReadableResult.FAILED;
            }
        }
        return ReadableResult.FAILED;
    }

    @Nullable
    private ReadResult readNextItem() throws IOException {
        if (this.unconsumedResult != null) {
            return this.unconsumedResult;
        }
        return this.reader.readNext();
    }

    @Override
    public synchronized boolean hasExpired() {
        return ClockBuddy.nowMillis(this.clock) >= this.expireTimeMillis;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    @NotNull
    public File getFile() {
        return this.file;
    }

    private void cleanUp() throws IOException {
        this.close();
        if (!this.file.delete()) {
            throw new IOException("Could not delete file: " + this.file);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed.compareAndSet(false, true)) {
            this.unconsumedResult = null;
            this.reader.close();
        }
    }

    public String toString() {
        return "ReadableFile{file=" + this.file + '}';
    }
}

