/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.exporter;

import io.opentelemetry.contrib.disk.buffering.internal.exporter.ToDiskExporterBuilder;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers.SignalSerializer;
import io.opentelemetry.contrib.disk.buffering.internal.storage.Storage;
import io.opentelemetry.contrib.disk.buffering.internal.utils.DebugLogger;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ToDiskExporter<EXPORT_DATA> {
    private final DebugLogger logger;
    private final Storage storage;
    private final SignalSerializer<EXPORT_DATA> serializer;
    private final Function<Collection<EXPORT_DATA>, CompletableResultCode> exportFunction;

    ToDiskExporter(SignalSerializer<EXPORT_DATA> serializer, Function<Collection<EXPORT_DATA>, CompletableResultCode> exportFunction, Storage storage) {
        this.serializer = serializer;
        this.exportFunction = exportFunction;
        this.storage = storage;
        this.logger = DebugLogger.wrap(Logger.getLogger(ToDiskExporter.class.getName()), storage.isDebugEnabled());
    }

    public static <T> ToDiskExporterBuilder<T> builder(Storage storage) {
        return new ToDiskExporterBuilder(storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableResultCode export(Collection<EXPORT_DATA> data) {
        this.logger.log("Intercepting exporter batch.", Level.FINER);
        try {
            this.serializer.initialize(data);
            if (this.storage.write(this.serializer)) {
                CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
                return completableResultCode;
            }
            this.logger.log("Could not store batch in disk. Exporting it right away.");
            CompletableResultCode completableResultCode = this.exportFunction.apply(data);
            return completableResultCode;
        }
        catch (IOException e) {
            this.logger.log("An unexpected error happened while attempting to write the data in disk. Exporting it right away.", Level.WARNING, e);
            CompletableResultCode completableResultCode = this.exportFunction.apply(data);
            return completableResultCode;
        }
        finally {
            this.serializer.reset();
        }
    }

    public void shutdown() throws IOException {
        this.storage.close();
    }
}

