/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.exporter;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.contrib.disk.buffering.internal.exporter.FromDiskExporterImpl;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.deserializers.SignalDeserializer;
import io.opentelemetry.contrib.disk.buffering.internal.storage.Storage;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class FromDiskExporterBuilder<T> {
    private SignalDeserializer<T> serializer = FromDiskExporterBuilder.noopDeserializer();
    private final Storage storage;
    private Function<Collection<T>, CompletableResultCode> exportFunction = x -> CompletableResultCode.ofFailure();

    public FromDiskExporterBuilder(Storage storage) {
        if (storage == null) {
            throw new NullPointerException("Storage cannot be null");
        }
        this.storage = storage;
    }

    @NotNull
    private static <T> SignalDeserializer<T> noopDeserializer() {
        return x -> Collections.emptyList();
    }

    @CanIgnoreReturnValue
    public FromDiskExporterBuilder<T> setDeserializer(SignalDeserializer<T> serializer) {
        this.serializer = serializer;
        return this;
    }

    @CanIgnoreReturnValue
    public FromDiskExporterBuilder<T> setExportFunction(Function<Collection<T>, CompletableResultCode> exportFunction) {
        this.exportFunction = exportFunction;
        return this;
    }

    public FromDiskExporterImpl<T> build() throws IOException {
        return new FromDiskExporterImpl<T>(this.serializer, this.exportFunction, this.storage);
    }
}

