/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering;

import io.opentelemetry.contrib.disk.buffering.internal.exporter.ToDiskExporter;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers.SignalSerializer;
import io.opentelemetry.contrib.disk.buffering.internal.storage.Storage;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.io.IOException;
import java.util.Collection;

public class LogRecordToDiskExporter
implements LogRecordExporter {
    private final ToDiskExporter<LogRecordData> delegate;

    public static LogRecordToDiskExporter create(LogRecordExporter delegate, Storage storage) {
        ToDiskExporter<LogRecordData> toDisk = ToDiskExporter.builder(storage).setSerializer(SignalSerializer.ofLogs()).setExportFunction(arg_0 -> ((LogRecordExporter)delegate).export(arg_0)).build();
        return new LogRecordToDiskExporter(toDisk);
    }

    LogRecordToDiskExporter(ToDiskExporter<LogRecordData> delegate) {
        this.delegate = delegate;
    }

    public CompletableResultCode export(Collection<LogRecordData> logs) {
        return this.delegate.export(logs);
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        try {
            this.delegate.shutdown();
            return CompletableResultCode.ofSuccess();
        }
        catch (IOException e) {
            return CompletableResultCode.ofFailure();
        }
    }
}

