/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.common;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributeType;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.diskbuffering.proto.common.v1.AnyValue;
import io.opentelemetry.diskbuffering.proto.common.v1.ArrayValue;
import io.opentelemetry.diskbuffering.proto.common.v1.KeyValue;
import java.util.ArrayList;
import java.util.List;

public final class AttributesMapper {
    private static final AttributesMapper INSTANCE = new AttributesMapper();

    public static AttributesMapper getInstance() {
        return INSTANCE;
    }

    public List<KeyValue> attributesToProto(Attributes attributes) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        attributes.forEach((attributeKey, o) -> keyValues.add(AttributesMapper.attributeEntryToProto(attributeKey, o)));
        return keyValues;
    }

    public Attributes protoToAttributes(List<KeyValue> values) {
        AttributesBuilder builder = Attributes.builder();
        for (KeyValue keyValue : values) {
            AttributesMapper.addValue(builder, keyValue.key, keyValue.value);
        }
        return builder.build();
    }

    private static KeyValue attributeEntryToProto(AttributeKey<?> key, Object value) {
        KeyValue.Builder builder = new KeyValue.Builder();
        builder.key(key.getKey());
        builder.value(AttributesMapper.attributeValueToProto(key.getType(), value));
        return builder.build();
    }

    private static AnyValue attributeValueToProto(AttributeType type, Object value) {
        switch (type) {
            case STRING: {
                return AttributesMapper.stringToAnyValue((String)value);
            }
            case BOOLEAN: {
                return AttributesMapper.booleanToAnyValue((Boolean)value);
            }
            case LONG: {
                return AttributesMapper.longToAnyValue((Long)value);
            }
            case DOUBLE: {
                return AttributesMapper.doubleToAnyValue((Double)value);
            }
            case STRING_ARRAY: {
                return AttributesMapper.arrayToAnyValue(AttributesMapper.stringListToAnyValue((List)value));
            }
            case BOOLEAN_ARRAY: {
                return AttributesMapper.arrayToAnyValue(AttributesMapper.booleanListToAnyValue((List)value));
            }
            case LONG_ARRAY: {
                return AttributesMapper.arrayToAnyValue(AttributesMapper.longListToAnyValue((List)value));
            }
            case DOUBLE_ARRAY: {
                return AttributesMapper.arrayToAnyValue(AttributesMapper.doubleListToAnyValue((List)value));
            }
        }
        throw new UnsupportedOperationException();
    }

    private static AnyValue arrayToAnyValue(List<AnyValue> value) {
        return new AnyValue.Builder().array_value(new ArrayValue.Builder().values(value).build()).build();
    }

    private static void addValue(AttributesBuilder builder, String key, AnyValue value) {
        if (value.string_value != null) {
            builder.put(AttributeKey.stringKey((String)key), (Object)value.string_value);
        } else if (value.bool_value != null) {
            builder.put(AttributeKey.booleanKey((String)key), (Object)value.bool_value);
        } else if (value.int_value != null) {
            builder.put(AttributeKey.longKey((String)key), (Object)value.int_value);
        } else if (value.double_value != null) {
            builder.put(AttributeKey.doubleKey((String)key), (Object)value.double_value);
        } else if (value.array_value != null) {
            AttributesMapper.addArray(builder, key, value.array_value);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private static void addArray(AttributesBuilder builder, String key, ArrayValue arrayValue) {
        List<AnyValue> values = arrayValue.values;
        AnyValue anyValue = values.get(0);
        if (anyValue.string_value != null) {
            builder.put(AttributeKey.stringArrayKey((String)key), AttributesMapper.anyValuesToStrings(values));
        } else if (anyValue.bool_value != null) {
            builder.put(AttributeKey.booleanArrayKey((String)key), AttributesMapper.anyValuesToBooleans(values));
        } else if (anyValue.int_value != null) {
            builder.put(AttributeKey.longArrayKey((String)key), AttributesMapper.anyValuesToLongs(values));
        } else if (anyValue.double_value != null) {
            builder.put(AttributeKey.doubleArrayKey((String)key), AttributesMapper.anyValuesToDoubles(values));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private static AnyValue stringToAnyValue(String value) {
        AnyValue.Builder anyValue = new AnyValue.Builder();
        anyValue.string_value(value);
        return anyValue.build();
    }

    private static AnyValue booleanToAnyValue(Boolean value) {
        AnyValue.Builder anyValue = new AnyValue.Builder();
        if (value != null) {
            anyValue.bool_value(value);
        }
        return anyValue.build();
    }

    private static AnyValue longToAnyValue(Long value) {
        AnyValue.Builder anyValue = new AnyValue.Builder();
        if (value != null) {
            anyValue.int_value(value);
        }
        return anyValue.build();
    }

    private static AnyValue doubleToAnyValue(Double value) {
        AnyValue.Builder anyValue = new AnyValue.Builder();
        if (value != null) {
            anyValue.double_value(value);
        }
        return anyValue.build();
    }

    private static List<AnyValue> stringListToAnyValue(List<String> value) {
        ArrayList<AnyValue> list = new ArrayList<AnyValue>(value.size());
        for (String string : value) {
            list.add(AttributesMapper.stringToAnyValue(string));
        }
        return list;
    }

    private static List<AnyValue> booleanListToAnyValue(List<Boolean> value) {
        ArrayList<AnyValue> list = new ArrayList<AnyValue>(value.size());
        for (Boolean boolean1 : value) {
            list.add(AttributesMapper.booleanToAnyValue(boolean1));
        }
        return list;
    }

    private static List<AnyValue> longListToAnyValue(List<Long> value) {
        ArrayList<AnyValue> list = new ArrayList<AnyValue>(value.size());
        for (Long long1 : value) {
            list.add(AttributesMapper.longToAnyValue(long1));
        }
        return list;
    }

    private static List<AnyValue> doubleListToAnyValue(List<Double> value) {
        ArrayList<AnyValue> list = new ArrayList<AnyValue>(value.size());
        for (Double double1 : value) {
            list.add(AttributesMapper.doubleToAnyValue(double1));
        }
        return list;
    }

    private static List<String> anyValuesToStrings(List<AnyValue> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AnyValue anyValue : values) {
            list.add(AttributesMapper.anyValueToString(anyValue));
        }
        return list;
    }

    private static List<Boolean> anyValuesToBooleans(List<AnyValue> values) {
        ArrayList<Boolean> list = new ArrayList<Boolean>(values.size());
        for (AnyValue anyValue : values) {
            list.add(AttributesMapper.anyValueToBoolean(anyValue));
        }
        return list;
    }

    private static List<Long> anyValuesToLongs(List<AnyValue> values) {
        ArrayList<Long> list = new ArrayList<Long>(values.size());
        for (AnyValue anyValue : values) {
            list.add(AttributesMapper.anyValueToLong(anyValue));
        }
        return list;
    }

    private static List<Double> anyValuesToDoubles(List<AnyValue> values) {
        ArrayList<Double> list = new ArrayList<Double>(values.size());
        for (AnyValue anyValue : values) {
            list.add(AttributesMapper.anyValueToDouble(anyValue));
        }
        return list;
    }

    private static String anyValueToString(AnyValue value) {
        return value.string_value;
    }

    private static Boolean anyValueToBoolean(AnyValue value) {
        return value.bool_value;
    }

    private static Long anyValueToLong(AnyValue value) {
        return value.int_value;
    }

    private static Double anyValueToDouble(AnyValue value) {
        return value.double_value;
    }
}

