/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.exporter;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.contrib.disk.buffering.config.StorageConfiguration;
import io.opentelemetry.contrib.disk.buffering.internal.exporter.FromDiskExporterImpl;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.deserializers.SignalDeserializer;
import io.opentelemetry.contrib.disk.buffering.internal.storage.Storage;
import io.opentelemetry.contrib.disk.buffering.internal.storage.StorageBuilder;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class FromDiskExporterBuilder<T> {
    private SignalDeserializer<T> serializer = FromDiskExporterBuilder.noopDeserializer();
    private Function<Collection<T>, CompletableResultCode> exportFunction = x -> CompletableResultCode.ofFailure();
    private boolean debugEnabled = false;
    private final StorageBuilder storageBuilder = Storage.builder();

    @NotNull
    private static <T> SignalDeserializer<T> noopDeserializer() {
        return x -> Collections.emptyList();
    }

    @CanIgnoreReturnValue
    public FromDiskExporterBuilder<T> setFolderName(String folderName) {
        this.storageBuilder.setFolderName(folderName);
        return this;
    }

    @CanIgnoreReturnValue
    public FromDiskExporterBuilder<T> setStorageConfiguration(StorageConfiguration configuration) {
        this.storageBuilder.setStorageConfiguration(configuration);
        return this;
    }

    @CanIgnoreReturnValue
    public FromDiskExporterBuilder<T> setStorageClock(Clock clock) {
        this.storageBuilder.setStorageClock(clock);
        return this;
    }

    @CanIgnoreReturnValue
    public FromDiskExporterBuilder<T> setDeserializer(SignalDeserializer<T> serializer) {
        this.serializer = serializer;
        return this;
    }

    @CanIgnoreReturnValue
    public FromDiskExporterBuilder<T> setExportFunction(Function<Collection<T>, CompletableResultCode> exportFunction) {
        this.exportFunction = exportFunction;
        return this;
    }

    @CanIgnoreReturnValue
    public FromDiskExporterBuilder<T> enableDebug() {
        return this.setDebugEnabled(true);
    }

    @CanIgnoreReturnValue
    public FromDiskExporterBuilder<T> setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
        return this;
    }

    public FromDiskExporterImpl<T> build() throws IOException {
        Storage storage = this.storageBuilder.build();
        return new FromDiskExporterImpl<T>(this.serializer, this.exportFunction, storage, this.debugEnabled);
    }
}

