/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.config;

import io.opentelemetry.contrib.disk.buffering.config.StorageConfiguration;
import io.opentelemetry.contrib.disk.buffering.config.TemporaryFileProvider;
import java.io.File;

final class AutoValue_StorageConfiguration
extends StorageConfiguration {
    private final File rootDir;
    private final boolean debugEnabled;
    private final long maxFileAgeForWriteMillis;
    private final long minFileAgeForReadMillis;
    private final long maxFileAgeForReadMillis;
    private final int maxFileSize;
    private final int maxFolderSize;
    private final TemporaryFileProvider temporaryFileProvider;

    private AutoValue_StorageConfiguration(File rootDir, boolean debugEnabled, long maxFileAgeForWriteMillis, long minFileAgeForReadMillis, long maxFileAgeForReadMillis, int maxFileSize, int maxFolderSize, TemporaryFileProvider temporaryFileProvider) {
        this.rootDir = rootDir;
        this.debugEnabled = debugEnabled;
        this.maxFileAgeForWriteMillis = maxFileAgeForWriteMillis;
        this.minFileAgeForReadMillis = minFileAgeForReadMillis;
        this.maxFileAgeForReadMillis = maxFileAgeForReadMillis;
        this.maxFileSize = maxFileSize;
        this.maxFolderSize = maxFolderSize;
        this.temporaryFileProvider = temporaryFileProvider;
    }

    @Override
    public File getRootDir() {
        return this.rootDir;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    @Override
    public long getMaxFileAgeForWriteMillis() {
        return this.maxFileAgeForWriteMillis;
    }

    @Override
    public long getMinFileAgeForReadMillis() {
        return this.minFileAgeForReadMillis;
    }

    @Override
    public long getMaxFileAgeForReadMillis() {
        return this.maxFileAgeForReadMillis;
    }

    @Override
    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    @Override
    public int getMaxFolderSize() {
        return this.maxFolderSize;
    }

    @Override
    public TemporaryFileProvider getTemporaryFileProvider() {
        return this.temporaryFileProvider;
    }

    public String toString() {
        return "StorageConfiguration{rootDir=" + this.rootDir + ", debugEnabled=" + this.debugEnabled + ", maxFileAgeForWriteMillis=" + this.maxFileAgeForWriteMillis + ", minFileAgeForReadMillis=" + this.minFileAgeForReadMillis + ", maxFileAgeForReadMillis=" + this.maxFileAgeForReadMillis + ", maxFileSize=" + this.maxFileSize + ", maxFolderSize=" + this.maxFolderSize + ", temporaryFileProvider=" + this.temporaryFileProvider + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof StorageConfiguration) {
            StorageConfiguration that = (StorageConfiguration)o;
            return this.rootDir.equals(that.getRootDir()) && this.debugEnabled == that.isDebugEnabled() && this.maxFileAgeForWriteMillis == that.getMaxFileAgeForWriteMillis() && this.minFileAgeForReadMillis == that.getMinFileAgeForReadMillis() && this.maxFileAgeForReadMillis == that.getMaxFileAgeForReadMillis() && this.maxFileSize == that.getMaxFileSize() && this.maxFolderSize == that.getMaxFolderSize() && this.temporaryFileProvider.equals(that.getTemporaryFileProvider());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.rootDir.hashCode();
        h$ *= 1000003;
        h$ ^= this.debugEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= (int)(this.maxFileAgeForWriteMillis >>> 32 ^ this.maxFileAgeForWriteMillis);
        h$ *= 1000003;
        h$ ^= (int)(this.minFileAgeForReadMillis >>> 32 ^ this.minFileAgeForReadMillis);
        h$ *= 1000003;
        h$ ^= (int)(this.maxFileAgeForReadMillis >>> 32 ^ this.maxFileAgeForReadMillis);
        h$ *= 1000003;
        h$ ^= this.maxFileSize;
        h$ *= 1000003;
        h$ ^= this.maxFolderSize;
        h$ *= 1000003;
        return h$ ^= this.temporaryFileProvider.hashCode();
    }

    static final class Builder
    extends StorageConfiguration.Builder {
        private File rootDir;
        private boolean debugEnabled;
        private long maxFileAgeForWriteMillis;
        private long minFileAgeForReadMillis;
        private long maxFileAgeForReadMillis;
        private int maxFileSize;
        private int maxFolderSize;
        private TemporaryFileProvider temporaryFileProvider;
        private byte set$0;

        Builder() {
        }

        @Override
        public StorageConfiguration.Builder setRootDir(File rootDir) {
            if (rootDir == null) {
                throw new NullPointerException("Null rootDir");
            }
            this.rootDir = rootDir;
            return this;
        }

        @Override
        public StorageConfiguration.Builder setDebugEnabled(boolean debugEnabled) {
            this.debugEnabled = debugEnabled;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public StorageConfiguration.Builder setMaxFileAgeForWriteMillis(long maxFileAgeForWriteMillis) {
            this.maxFileAgeForWriteMillis = maxFileAgeForWriteMillis;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public StorageConfiguration.Builder setMinFileAgeForReadMillis(long minFileAgeForReadMillis) {
            this.minFileAgeForReadMillis = minFileAgeForReadMillis;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public StorageConfiguration.Builder setMaxFileAgeForReadMillis(long maxFileAgeForReadMillis) {
            this.maxFileAgeForReadMillis = maxFileAgeForReadMillis;
            this.set$0 = (byte)(this.set$0 | 8);
            return this;
        }

        @Override
        public StorageConfiguration.Builder setMaxFileSize(int maxFileSize) {
            this.maxFileSize = maxFileSize;
            this.set$0 = (byte)(this.set$0 | 0x10);
            return this;
        }

        @Override
        public StorageConfiguration.Builder setMaxFolderSize(int maxFolderSize) {
            this.maxFolderSize = maxFolderSize;
            this.set$0 = (byte)(this.set$0 | 0x20);
            return this;
        }

        @Override
        public StorageConfiguration.Builder setTemporaryFileProvider(TemporaryFileProvider temporaryFileProvider) {
            if (temporaryFileProvider == null) {
                throw new NullPointerException("Null temporaryFileProvider");
            }
            this.temporaryFileProvider = temporaryFileProvider;
            return this;
        }

        @Override
        public StorageConfiguration build() {
            if (this.set$0 != 63 || this.rootDir == null || this.temporaryFileProvider == null) {
                StringBuilder missing = new StringBuilder();
                if (this.rootDir == null) {
                    missing.append(" rootDir");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" debugEnabled");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" maxFileAgeForWriteMillis");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" minFileAgeForReadMillis");
                }
                if ((this.set$0 & 8) == 0) {
                    missing.append(" maxFileAgeForReadMillis");
                }
                if ((this.set$0 & 0x10) == 0) {
                    missing.append(" maxFileSize");
                }
                if ((this.set$0 & 0x20) == 0) {
                    missing.append(" maxFolderSize");
                }
                if (this.temporaryFileProvider == null) {
                    missing.append(" temporaryFileProvider");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_StorageConfiguration(this.rootDir, this.debugEnabled, this.maxFileAgeForWriteMillis, this.minFileAgeForReadMillis, this.maxFileAgeForReadMillis, this.maxFileSize, this.maxFolderSize, this.temporaryFileProvider);
        }
    }
}

