/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.spans;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.propagation.internal.W3CTraceContextEncoding;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.common.AttributesMapper;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.common.ByteStringMapper;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.spans.models.SpanDataImpl;
import io.opentelemetry.contrib.disk.buffering.internal.utils.ProtobufTools;
import io.opentelemetry.diskbuffering.proto.common.v1.KeyValue;
import io.opentelemetry.diskbuffering.proto.trace.v1.Span;
import io.opentelemetry.diskbuffering.proto.trace.v1.Status;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class SpanDataMapper {
    private static final SpanDataMapper INSTANCE = new SpanDataMapper();
    private final ByteStringMapper byteStringMapper = ByteStringMapper.getInstance();

    public static SpanDataMapper getInstance() {
        return INSTANCE;
    }

    public Span mapToProto(SpanData source) {
        Span.Builder span = new Span.Builder();
        span.start_time_unix_nano(source.getStartEpochNanos());
        span.end_time_unix_nano(source.getEndEpochNanos());
        if (source.getEvents() != null) {
            for (EventData event : source.getEvents()) {
                span.events.add(SpanDataMapper.eventDataToProto(event));
            }
        }
        if (source.getLinks() != null) {
            for (LinkData link : source.getLinks()) {
                span.links.add(SpanDataMapper.linkDataToProto(link));
            }
        }
        span.trace_id(this.byteStringMapper.stringToProto(source.getTraceId()));
        span.span_id(this.byteStringMapper.stringToProto(source.getSpanId()));
        span.flags(source.getSpanContext().getTraceFlags().asByte());
        span.parent_span_id(this.byteStringMapper.stringToProto(source.getParentSpanId()));
        span.name(source.getName());
        span.kind(SpanDataMapper.mapSpanKindToProto(source.getKind()));
        span.status(SpanDataMapper.statusDataToProto(source.getStatus()));
        SpanDataMapper.addSpanProtoExtras(source, span);
        return span.build();
    }

    private static void addSpanProtoExtras(SpanData source, Span.Builder target) {
        target.attributes.addAll(SpanDataMapper.attributesToProto(source.getAttributes()));
        target.dropped_attributes_count(source.getTotalAttributeCount() - source.getAttributes().size());
        target.dropped_events_count(source.getTotalRecordedEvents() - SpanDataMapper.getListSize(source.getEvents()));
        target.dropped_links_count(source.getTotalRecordedLinks() - SpanDataMapper.getListSize(source.getLinks()));
        target.trace_state(SpanDataMapper.encodeTraceState(source.getSpanContext().getTraceState()));
    }

    public SpanData mapToSdk(Span source, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo) {
        SpanDataImpl.Builder spanData = SpanDataImpl.builder();
        spanData.setStartEpochNanos(source.start_time_unix_nano);
        spanData.setEndEpochNanos(source.end_time_unix_nano);
        spanData.setEvents(SpanDataMapper.eventListToEventDataList(source.events));
        spanData.setLinks(SpanDataMapper.linkListToLinkDataList(source.links));
        spanData.setName(source.name);
        spanData.setKind(SpanDataMapper.mapSpanKindToSdk(source.kind));
        if (source.status != null) {
            spanData.setStatus(SpanDataMapper.mapStatusDataToSdk(source.status));
        }
        SpanDataMapper.addSpanDataExtras(source, spanData, resource, instrumentationScopeInfo);
        return spanData.build();
    }

    private static void addSpanDataExtras(Span source, SpanDataImpl.Builder target, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo) {
        Attributes attributes = SpanDataMapper.protoToAttributes(source.attributes);
        target.setAttributes(attributes);
        target.setResource(resource);
        target.setInstrumentationScopeInfo(instrumentationScopeInfo);
        String traceId = ByteStringMapper.getInstance().protoToString(source.trace_id);
        target.setSpanContext(SpanContext.create((String)traceId, (String)ByteStringMapper.getInstance().protoToString(source.span_id), (TraceFlags)SpanDataMapper.flagsFromInt(source.flags), (TraceState)SpanDataMapper.decodeTraceState(source.trace_state)));
        target.setParentSpanContext(SpanContext.create((String)traceId, (String)ByteStringMapper.getInstance().protoToString(source.parent_span_id), (TraceFlags)TraceFlags.getSampled(), (TraceState)TraceState.getDefault()));
        target.setTotalAttributeCount(source.dropped_attributes_count + attributes.size());
        target.setTotalRecordedEvents(SpanDataMapper.calculateRecordedItems(source.dropped_events_count, source.events.size()));
        target.setTotalRecordedLinks(SpanDataMapper.calculateRecordedItems(source.dropped_links_count, source.links.size()));
    }

    private static StatusData mapStatusDataToSdk(Status source) {
        return StatusData.create((StatusCode)SpanDataMapper.getStatusCode(source.code), (String)source.message);
    }

    private static Span.Event eventDataToProto(EventData source) {
        Span.Event.Builder event = new Span.Event.Builder();
        event.time_unix_nano(source.getEpochNanos());
        event.name(source.getName());
        event.dropped_attributes_count(source.getDroppedAttributesCount());
        SpanDataMapper.addEventProtoExtras(source, event);
        return event.build();
    }

    private static void addEventProtoExtras(EventData source, Span.Event.Builder target) {
        target.attributes.addAll(SpanDataMapper.attributesToProto(source.getAttributes()));
    }

    private static Status statusDataToProto(StatusData source) {
        Status.Builder status = new Status.Builder();
        status.message(source.getDescription());
        status.code(SpanDataMapper.mapStatusCodeToProto(source.getStatusCode()));
        return status.build();
    }

    private static Span.SpanKind mapSpanKindToProto(SpanKind source) {
        Span.SpanKind spanKind;
        switch (source) {
            case INTERNAL: {
                spanKind = Span.SpanKind.SPAN_KIND_INTERNAL;
                break;
            }
            case SERVER: {
                spanKind = Span.SpanKind.SPAN_KIND_SERVER;
                break;
            }
            case CLIENT: {
                spanKind = Span.SpanKind.SPAN_KIND_CLIENT;
                break;
            }
            case PRODUCER: {
                spanKind = Span.SpanKind.SPAN_KIND_PRODUCER;
                break;
            }
            case CONSUMER: {
                spanKind = Span.SpanKind.SPAN_KIND_CONSUMER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + source);
            }
        }
        return spanKind;
    }

    private static Status.StatusCode mapStatusCodeToProto(StatusCode source) {
        Status.StatusCode statusCode;
        switch (source) {
            case UNSET: {
                statusCode = Status.StatusCode.STATUS_CODE_UNSET;
                break;
            }
            case OK: {
                statusCode = Status.StatusCode.STATUS_CODE_OK;
                break;
            }
            case ERROR: {
                statusCode = Status.StatusCode.STATUS_CODE_ERROR;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + source);
            }
        }
        return statusCode;
    }

    private static EventData eventDataToSdk(Span.Event source) {
        Attributes attributes = SpanDataMapper.protoToAttributes(source.attributes);
        return EventData.create((long)source.time_unix_nano, (String)source.name, (Attributes)attributes, (int)(attributes.size() + source.dropped_attributes_count));
    }

    private static SpanKind mapSpanKindToSdk(Span.SpanKind source) {
        SpanKind spanKind;
        switch (source) {
            case SPAN_KIND_INTERNAL: {
                spanKind = SpanKind.INTERNAL;
                break;
            }
            case SPAN_KIND_SERVER: {
                spanKind = SpanKind.SERVER;
                break;
            }
            case SPAN_KIND_CLIENT: {
                spanKind = SpanKind.CLIENT;
                break;
            }
            case SPAN_KIND_PRODUCER: {
                spanKind = SpanKind.PRODUCER;
                break;
            }
            case SPAN_KIND_CONSUMER: {
                spanKind = SpanKind.CONSUMER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + (Object)((Object)source));
            }
        }
        return spanKind;
    }

    private static List<EventData> eventListToEventDataList(List<Span.Event> list) {
        ArrayList<EventData> result = new ArrayList<EventData>(list.size());
        for (Span.Event event : list) {
            result.add(SpanDataMapper.eventDataToSdk(event));
        }
        return result;
    }

    private static List<LinkData> linkListToLinkDataList(List<Span.Link> list) {
        ArrayList<LinkData> result = new ArrayList<LinkData>(list.size());
        for (Span.Link link : list) {
            result.add(SpanDataMapper.linkDataToSdk(link));
        }
        return result;
    }

    private static LinkData linkDataToSdk(Span.Link source) {
        Attributes attributes = SpanDataMapper.protoToAttributes(source.attributes);
        int totalAttrCount = source.dropped_attributes_count + attributes.size();
        SpanContext spanContext = SpanContext.create((String)ByteStringMapper.getInstance().protoToString(source.trace_id), (String)ByteStringMapper.getInstance().protoToString(source.span_id), (TraceFlags)SpanDataMapper.flagsFromInt(source.flags), (TraceState)SpanDataMapper.decodeTraceState(source.trace_state));
        return LinkData.create((SpanContext)spanContext, (Attributes)attributes, (int)totalAttrCount);
    }

    private static int calculateRecordedItems(int droppedCount, int itemsCount) {
        return droppedCount + itemsCount;
    }

    private static StatusCode getStatusCode(Status.StatusCode source) {
        switch (source) {
            case STATUS_CODE_UNSET: {
                return StatusCode.UNSET;
            }
            case STATUS_CODE_OK: {
                return StatusCode.OK;
            }
            case STATUS_CODE_ERROR: {
                return StatusCode.ERROR;
            }
        }
        throw new IllegalArgumentException("Unexpected enum constant: " + (Object)((Object)source));
    }

    private static List<KeyValue> attributesToProto(Attributes source) {
        return AttributesMapper.getInstance().attributesToProto(source);
    }

    private static Attributes protoToAttributes(List<KeyValue> source) {
        return AttributesMapper.getInstance().protoToAttributes(source);
    }

    private static int getListSize(List<?> list) {
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    private static String encodeTraceState(TraceState traceState) {
        if (!traceState.isEmpty()) {
            return W3CTraceContextEncoding.encodeTraceState((TraceState)traceState);
        }
        return "";
    }

    private static TraceState decodeTraceState(@Nullable String source) {
        return source == null || source.isEmpty() ? TraceState.getDefault() : W3CTraceContextEncoding.decodeTraceState((String)source);
    }

    private static Span.Link linkDataToProto(LinkData source) {
        Span.Link.Builder builder = new Span.Link.Builder();
        SpanContext spanContext = source.getSpanContext();
        builder.trace_id(ByteStringMapper.getInstance().stringToProto(spanContext.getTraceId()));
        builder.span_id(ByteStringMapper.getInstance().stringToProto(spanContext.getSpanId()));
        builder.flags = ProtobufTools.toUnsignedInt(spanContext.getTraceFlags().asByte());
        builder.attributes.addAll(SpanDataMapper.attributesToProto(source.getAttributes()));
        builder.dropped_attributes_count(source.getTotalAttributeCount() - source.getAttributes().size());
        builder.trace_state(SpanDataMapper.encodeTraceState(spanContext.getTraceState()));
        return builder.build();
    }

    public static TraceFlags flagsFromInt(int b) {
        return TraceFlags.fromByte((byte)((byte)(b & 0xFF)));
    }
}

