/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.exporter;

import io.opentelemetry.contrib.disk.buffering.internal.exporter.FromDiskExporter;
import io.opentelemetry.contrib.disk.buffering.internal.exporter.FromDiskExporterBuilder;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.deserializers.SignalDeserializer;
import io.opentelemetry.contrib.disk.buffering.internal.storage.Storage;
import io.opentelemetry.contrib.disk.buffering.internal.storage.responses.ReadableResult;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FromDiskExporterImpl<EXPORT_DATA>
implements FromDiskExporter {
    private final Storage storage;
    private final SignalDeserializer<EXPORT_DATA> deserializer;
    private final Function<Collection<EXPORT_DATA>, CompletableResultCode> exportFunction;
    private static final Logger logger = Logger.getLogger(FromDiskExporterImpl.class.getName());

    FromDiskExporterImpl(SignalDeserializer<EXPORT_DATA> deserializer, Function<Collection<EXPORT_DATA>, CompletableResultCode> exportFunction, Storage storage) {
        this.deserializer = deserializer;
        this.exportFunction = exportFunction;
        this.storage = storage;
    }

    public static <T> FromDiskExporterBuilder<T> builder() {
        return new FromDiskExporterBuilder();
    }

    @Override
    public boolean exportStoredBatch(long timeout, TimeUnit unit) throws IOException {
        logger.log(Level.INFO, "Attempting to export batch from disk.");
        ReadableResult result = this.storage.readAndProcess(bytes -> {
            logger.log(Level.INFO, "About to export stored batch.");
            CompletableResultCode join = this.exportFunction.apply(this.deserializer.deserialize((byte[])bytes)).join(timeout, unit);
            return join.isSuccess();
        });
        return result == ReadableResult.SUCCEEDED;
    }

    @Override
    public void shutdown() throws IOException {
        this.storage.close();
    }
}

