/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering;

import io.opentelemetry.contrib.disk.buffering.StoredBatchExporter;
import io.opentelemetry.contrib.disk.buffering.internal.StorageConfiguration;
import io.opentelemetry.contrib.disk.buffering.internal.exporters.DiskExporter;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers.SignalSerializer;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public final class MetricDiskExporter
implements MetricExporter,
StoredBatchExporter {
    private final MetricExporter wrapped;
    private final DiskExporter<MetricData> diskExporter;

    public static MetricDiskExporter create(MetricExporter wrapped, File rootDir, StorageConfiguration configuration) throws IOException {
        return MetricDiskExporter.create(wrapped, rootDir, configuration, Clock.getDefault());
    }

    public static MetricDiskExporter create(MetricExporter wrapped, File rootDir, StorageConfiguration configuration, Clock clock) throws IOException {
        DiskExporter<MetricData> diskExporter = DiskExporter.builder().setRootDir(rootDir).setFolderName("metrics").setStorageConfiguration(configuration).setSerializer(SignalSerializer.ofMetrics()).setExportFunction(arg_0 -> ((MetricExporter)wrapped).export(arg_0)).setStorageClock(clock).build();
        return new MetricDiskExporter(wrapped, diskExporter);
    }

    private MetricDiskExporter(MetricExporter wrapped, DiskExporter<MetricData> diskExporter) {
        this.wrapped = wrapped;
        this.diskExporter = diskExporter;
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        return this.diskExporter.onExport(metrics);
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        try {
            this.diskExporter.onShutDown();
        }
        catch (IOException e) {
            CompletableResultCode completableResultCode = CompletableResultCode.ofFailure();
            return completableResultCode;
        }
        finally {
            this.wrapped.shutdown();
        }
        return CompletableResultCode.ofSuccess();
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.wrapped.getAggregationTemporality(instrumentType);
    }

    @Override
    public boolean exportStoredBatch(long timeout, TimeUnit unit) throws IOException {
        return this.diskExporter.exportStoredBatch(timeout, unit);
    }
}

