/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers;

import com.google.protobuf.InvalidProtocolBufferException;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.spans.ProtoSpansDataMapper;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers.SignalSerializer;
import io.opentelemetry.proto.trace.v1.TracesData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;

public final class SpanDataSerializer
implements SignalSerializer<SpanData> {
    private static final SpanDataSerializer INSTANCE = new SpanDataSerializer();

    private SpanDataSerializer() {
    }

    static SpanDataSerializer getInstance() {
        return INSTANCE;
    }

    @Override
    public byte[] serialize(Collection<SpanData> spanData) {
        byte[] byArray;
        TracesData proto = (TracesData)ProtoSpansDataMapper.getInstance().toProto(spanData);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            proto.writeDelimitedTo((OutputStream)out);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        out.close();
        return byArray;
    }

    @Override
    public List<SpanData> deserialize(byte[] source) {
        try {
            return ProtoSpansDataMapper.getInstance().fromProto(TracesData.parseFrom((byte[])source));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

