/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.logs;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.common.AttributesMapper;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.common.ByteStringMapper;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.logs.models.LogRecordDataImpl;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.logs.v1.LogRecord;
import io.opentelemetry.proto.logs.v1.SeverityNumber;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.logs.data.Body;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.resources.Resource;

public final class LogRecordDataMapper {
    private static final LogRecordDataMapper INSTANCE = new LogRecordDataMapper();

    public static LogRecordDataMapper getInstance() {
        return INSTANCE;
    }

    public LogRecord mapToProto(LogRecordData source) {
        LogRecord.Builder logRecord = LogRecord.newBuilder();
        logRecord.setTimeUnixNano(source.getTimestampEpochNanos());
        logRecord.setObservedTimeUnixNano(source.getObservedTimestampEpochNanos());
        if (source.getSeverity() != null) {
            logRecord.setSeverityNumber(LogRecordDataMapper.severityToProto(source.getSeverity()));
        }
        if (source.getSeverityText() != null) {
            logRecord.setSeverityText(source.getSeverityText());
        }
        if (source.getBody() != null) {
            logRecord.setBody(LogRecordDataMapper.bodyToAnyValue(source.getBody()));
        }
        logRecord.setFlags((int)source.getSpanContext().getTraceFlags().asByte());
        LogRecordDataMapper.addExtrasToProtoBuilder(source, logRecord);
        return logRecord.build();
    }

    private static void addExtrasToProtoBuilder(LogRecordData source, LogRecord.Builder target) {
        target.addAllAttributes(AttributesMapper.getInstance().attributesToProto(source.getAttributes()));
        SpanContext spanContext = source.getSpanContext();
        target.setSpanId(ByteStringMapper.getInstance().stringToProto(spanContext.getSpanId()));
        target.setTraceId(ByteStringMapper.getInstance().stringToProto(spanContext.getTraceId()));
        target.setDroppedAttributesCount(source.getTotalAttributeCount() - source.getAttributes().size());
    }

    public LogRecordData mapToSdk(LogRecord source, Resource resource, InstrumentationScopeInfo scopeInfo) {
        LogRecordDataImpl.Builder logRecordData = LogRecordDataImpl.builder();
        logRecordData.setTimestampEpochNanos(source.getTimeUnixNano());
        logRecordData.setObservedTimestampEpochNanos(source.getObservedTimeUnixNano());
        logRecordData.setSeverity(LogRecordDataMapper.severityNumberToSdk(source.getSeverityNumber()));
        logRecordData.setSeverityText(source.getSeverityText());
        if (source.hasBody()) {
            logRecordData.setBody(LogRecordDataMapper.anyValueToBody(source.getBody()));
        }
        LogRecordDataMapper.addExtrasToSdkItemBuilder(source, logRecordData, resource, scopeInfo);
        return logRecordData.build();
    }

    private static void addExtrasToSdkItemBuilder(LogRecord source, LogRecordDataImpl.Builder target, Resource resource, InstrumentationScopeInfo scopeInfo) {
        Attributes attributes = AttributesMapper.getInstance().protoToAttributes(source.getAttributesList());
        target.setAttributes(attributes);
        target.setSpanContext(SpanContext.create((String)ByteStringMapper.getInstance().protoToString(source.getTraceId()), (String)ByteStringMapper.getInstance().protoToString(source.getSpanId()), (TraceFlags)TraceFlags.getSampled(), (TraceState)TraceState.getDefault()));
        target.setTotalAttributeCount(source.getDroppedAttributesCount() + attributes.size());
        target.setResource(resource);
        target.setInstrumentationScopeInfo(scopeInfo);
    }

    private static AnyValue bodyToAnyValue(Body body) {
        return AnyValue.newBuilder().setStringValue(body.asString()).build();
    }

    private static SeverityNumber severityToProto(Severity severity) {
        return SeverityNumber.forNumber((int)severity.getSeverityNumber());
    }

    private static Body anyValueToBody(AnyValue source) {
        if (source.hasStringValue()) {
            return Body.string((String)source.getStringValue());
        }
        return Body.empty();
    }

    private static Severity severityNumberToSdk(SeverityNumber source) {
        for (Severity value : Severity.values()) {
            if (value.getSeverityNumber() != source.getNumber()) continue;
            return value;
        }
        throw new IllegalArgumentException();
    }
}

