/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent;

import io.opentelemetry.contrib.sampler.consistent.ConsistentSampler;
import io.opentelemetry.contrib.sampler.consistent.RValueGenerator;
import io.opentelemetry.contrib.sampler.consistent.RandomGenerator;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import javax.annotation.concurrent.Immutable;

final class ConsistentRateLimitingSampler
extends ConsistentSampler {
    private final String description;
    private final LongSupplier nanoTimeSupplier;
    private final double inverseAdaptationTimeNanos;
    private final double targetSpansPerNanosecondLimit;
    private final AtomicReference<State> state;
    private final RandomGenerator randomGenerator;

    ConsistentRateLimitingSampler(double targetSpansPerSecondLimit, double adaptationTimeSeconds, RValueGenerator rValueGenerator, RandomGenerator randomGenerator, LongSupplier nanoTimeSupplier) {
        super(rValueGenerator);
        if (targetSpansPerSecondLimit < 0.0) {
            throw new IllegalArgumentException("Limit for sampled spans per second must be nonnegative!");
        }
        if (adaptationTimeSeconds < 0.0) {
            throw new IllegalArgumentException("Adaptation rate must be nonnegative!");
        }
        this.description = String.format(Locale.ROOT, "ConsistentRateLimitingSampler{%.6f, %.6f}", targetSpansPerSecondLimit, adaptationTimeSeconds);
        this.nanoTimeSupplier = Objects.requireNonNull(nanoTimeSupplier);
        this.inverseAdaptationTimeNanos = 1.0E-9 / adaptationTimeSeconds;
        this.targetSpansPerNanosecondLimit = 1.0E-9 * targetSpansPerSecondLimit;
        this.state = new AtomicReference<State>(new State(0.0, 0.0, nanoTimeSupplier.getAsLong()));
        this.randomGenerator = randomGenerator;
    }

    private State updateState(State oldState, long currentNanoTime) {
        if (currentNanoTime <= oldState.lastNanoTime) {
            return new State(oldState.effectiveWindowCount + 1.0, oldState.effectiveWindowNanos, oldState.lastNanoTime);
        }
        long nanoTimeDelta = currentNanoTime - oldState.lastNanoTime;
        double decayFactor = Math.exp((double)(-nanoTimeDelta) * this.inverseAdaptationTimeNanos);
        double currentEffectiveWindowCount = oldState.effectiveWindowCount * decayFactor + 1.0;
        double currentEffectiveWindowNanos = oldState.effectiveWindowNanos * decayFactor + (double)nanoTimeDelta;
        return new State(currentEffectiveWindowCount, currentEffectiveWindowNanos, currentNanoTime);
    }

    @Override
    protected int getP(int parentP, boolean isRoot) {
        int upperPValue;
        long currentNanoTime = this.nanoTimeSupplier.getAsLong();
        State currentState = this.state.updateAndGet(s -> this.updateState((State)s, currentNanoTime));
        double samplingProbability = currentState.effectiveWindowNanos * this.targetSpansPerNanosecondLimit / currentState.effectiveWindowCount;
        if (samplingProbability >= 1.0) {
            return 0;
        }
        int lowerPValue = ConsistentRateLimitingSampler.getLowerBoundP(samplingProbability);
        if (lowerPValue == (upperPValue = ConsistentRateLimitingSampler.getUpperBoundP(samplingProbability))) {
            return lowerPValue;
        }
        double upperSamplingRate = ConsistentRateLimitingSampler.getSamplingProbability(lowerPValue);
        double lowerSamplingRate = ConsistentRateLimitingSampler.getSamplingProbability(upperPValue);
        double probabilityToUseLowerPValue = (samplingProbability - lowerSamplingRate) / (upperSamplingRate - lowerSamplingRate);
        if (this.randomGenerator.nextBoolean(probabilityToUseLowerPValue)) {
            return lowerPValue;
        }
        return upperPValue;
    }

    public String getDescription() {
        return this.description;
    }

    @Immutable
    private static final class State {
        private final double effectiveWindowCount;
        private final double effectiveWindowNanos;
        private final long lastNanoTime;

        State(double effectiveWindowCount, double effectiveWindowNanos, long lastNanoTime) {
            this.effectiveWindowCount = effectiveWindowCount;
            this.effectiveWindowNanos = effectiveWindowNanos;
            this.lastNanoTime = lastNanoTime;
        }
    }
}

