/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent56;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.sampler.consistent56.Composable;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSamplingUtil;
import io.opentelemetry.contrib.sampler.consistent56.OtelTraceState;
import io.opentelemetry.contrib.sampler.consistent56.SamplingIntent;
import io.opentelemetry.sdk.trace.data.LinkData;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ConsistentParentBasedSampler
extends ConsistentSampler {
    private final Composable rootSampler;
    private final String description;

    protected ConsistentParentBasedSampler(Composable rootSampler) {
        this.rootSampler = Objects.requireNonNull(rootSampler);
        this.description = "ConsistentParentBasedSampler{rootSampler=" + rootSampler.getDescription() + '}';
    }

    @Override
    public final SamplingIntent getSamplingIntent(Context parentContext, final String name, final SpanKind spanKind, final Attributes attributes, final List<LinkData> parentLinks) {
        boolean isParentAdjustedCountCorrect;
        long parentThreshold;
        boolean isRoot;
        Span parentSpan = Span.fromContext((Context)parentContext);
        final SpanContext parentSpanContext = parentSpan.getSpanContext();
        boolean bl = isRoot = !parentSpanContext.isValid();
        if (isRoot) {
            return this.rootSampler.getSamplingIntent(parentContext, name, spanKind, attributes, parentLinks);
        }
        TraceState parentTraceState = parentSpanContext.getTraceState();
        String otelTraceStateString = parentTraceState.get("ot");
        OtelTraceState otelTraceState = OtelTraceState.parse(otelTraceStateString);
        if (otelTraceState.hasValidThreshold()) {
            parentThreshold = otelTraceState.getThreshold();
            isParentAdjustedCountCorrect = true;
        } else {
            parentThreshold = parentSpanContext.isSampled() ? ConsistentSamplingUtil.getMinThreshold() : ConsistentSamplingUtil.getInvalidThreshold();
            isParentAdjustedCountCorrect = false;
        }
        return new SamplingIntent(){

            @Override
            public long getThreshold() {
                return parentThreshold;
            }

            @Override
            public boolean isAdjustedCountReliable() {
                return isParentAdjustedCountCorrect;
            }

            @Override
            public Attributes getAttributes() {
                if (parentSpanContext.isRemote()) {
                    return ConsistentParentBasedSampler.this.getAttributesWhenParentRemote(name, spanKind, attributes, parentLinks);
                }
                return ConsistentParentBasedSampler.this.getAttributesWhenParentLocal(name, spanKind, attributes, parentLinks);
            }

            @Override
            public TraceState updateTraceState(TraceState parentState) {
                return parentState;
            }
        };
    }

    protected Attributes getAttributesWhenParentLocal(String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        return Attributes.empty();
    }

    protected Attributes getAttributesWhenParentRemote(String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        return Attributes.empty();
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

