/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.samplers;

import java.util.BitSet;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.LongSupplier;

final class RandomGenerator {
    private final LongSupplier threadSafeRandomLongSupplier;
    private final ThreadLocal<ThreadLocalData> threadLocalData = ThreadLocal.withInitial(() -> new ThreadLocalData());
    private static final RandomGenerator INSTANCE = new RandomGenerator(() -> ThreadLocalRandom.current().nextLong());

    private RandomGenerator(LongSupplier threadSafeRandomLongSupplier) {
        this.threadSafeRandomLongSupplier = Objects.requireNonNull(threadSafeRandomLongSupplier);
    }

    public static RandomGenerator create(LongSupplier threadSafeRandomLongSupplier) {
        return new RandomGenerator(threadSafeRandomLongSupplier);
    }

    public static RandomGenerator getDefault() {
        return INSTANCE;
    }

    public boolean nextBoolean(double probability) {
        return this.threadLocalData.get().generateRandomBoolean(this.threadSafeRandomLongSupplier, probability);
    }

    public int numberOfLeadingZerosOfRandomLong() {
        return this.threadLocalData.get().numberOfLeadingZerosOfRandomLong(this.threadSafeRandomLongSupplier);
    }

    public long nextLong() {
        return this.threadSafeRandomLongSupplier.getAsLong();
    }

    public long roundStochastically(double x) {
        long i = (long)Math.floor(x);
        if (this.nextBoolean(x - (double)i)) {
            return i + 1L;
        }
        return i;
    }

    private int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException();
        }
        long x = this.nextLong() >>> 33;
        long m = x * (long)bound;
        int l = (int)m & Integer.MAX_VALUE;
        if (l < bound) {
            int t = (-bound & Integer.MAX_VALUE) % bound;
            while (l < t) {
                x = this.nextLong() >>> 33;
                m = x * (long)bound;
                l = (int)m & Integer.MAX_VALUE;
            }
        }
        return (int)(m >>> 31);
    }

    public BitSet generateRandomBitSet(int numBits, int numOneBits) {
        if (numOneBits < 0 || numOneBits > numBits) {
            throw new IllegalArgumentException();
        }
        BitSet result = new BitSet(numBits);
        int numZeroBits = numBits - numOneBits;
        for (int i = Math.max(numZeroBits, numOneBits); i < numBits; ++i) {
            int j = this.nextInt(i + 1);
            if (result.get(j)) {
                result.set(i);
                continue;
            }
            result.set(j);
        }
        if (numZeroBits < numOneBits) {
            result.flip(0, numBits);
        }
        return result;
    }

    private static final class ThreadLocalData {
        private long randomBits = 0L;
        private int bitCount = 0;

        private ThreadLocalData() {
        }

        private boolean nextRandomBit(LongSupplier threadSafeRandomLongSupplier) {
            if ((this.bitCount & 0x3F) == 0) {
                this.randomBits = threadSafeRandomLongSupplier.getAsLong();
            }
            boolean randomBit = (this.randomBits >>> this.bitCount & 1L) != 0L;
            ++this.bitCount;
            return randomBit;
        }

        private boolean generateRandomBoolean(LongSupplier threadSafeRandomLongSupplier, double probability) {
            while (!(probability <= 0.0)) {
                boolean b;
                if (probability >= 1.0) {
                    return true;
                }
                boolean bl = b = probability > 0.5;
                if (this.nextRandomBit(threadSafeRandomLongSupplier)) {
                    return b;
                }
                probability += probability;
                if (!b) continue;
                probability -= 1.0;
            }
            return false;
        }

        private int numberOfLeadingZerosOfRandomLong(LongSupplier threadSafeRandomLongSupplier) {
            int count;
            for (count = 0; count < 64 && this.nextRandomBit(threadSafeRandomLongSupplier); ++count) {
            }
            return count;
        }
    }
}

