/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.statemachine;

import io.openmessaging.storage.dledger.DLedgerEntryPusher;
import io.openmessaging.storage.dledger.entry.DLedgerEntry;
import io.openmessaging.storage.dledger.statemachine.CommittedEntryIterator;
import io.openmessaging.storage.dledger.statemachine.StateMachine;
import io.openmessaging.storage.dledger.store.DLedgerStore;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.rocketmq.remoting.common.ServiceThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachineCaller
extends ServiceThread {
    private static Logger logger = LoggerFactory.getLogger(StateMachineCaller.class);
    private final DLedgerStore dLedgerStore;
    private final StateMachine statemachine;
    private final DLedgerEntryPusher entryPusher;
    private final AtomicLong lastAppliedIndex;
    private long lastAppliedTerm;
    private final AtomicLong applyingIndex;
    private final BlockingQueue<ApplyTask> taskQueue;
    private final Function<Long, Boolean> completeEntryCallback;

    public StateMachineCaller(DLedgerStore dLedgerStore, StateMachine statemachine, DLedgerEntryPusher entryPusher) {
        this.dLedgerStore = dLedgerStore;
        this.statemachine = statemachine;
        this.entryPusher = entryPusher;
        this.lastAppliedIndex = new AtomicLong(-1L);
        this.applyingIndex = new AtomicLong(-1L);
        this.taskQueue = new LinkedBlockingQueue<ApplyTask>(1024);
        this.completeEntryCallback = entryPusher != null ? entryPusher::completeResponseFuture : index -> true;
    }

    private boolean enqueueTask(ApplyTask task) {
        return this.taskQueue.offer(task);
    }

    public StateMachine getStateMachine() {
        return this.statemachine;
    }

    public boolean onCommitted(long committedIndex) {
        ApplyTask task = new ApplyTask();
        task.type = TaskType.COMMITTED;
        task.committedIndex = committedIndex;
        return this.enqueueTask(task);
    }

    public boolean onSnapshotLoad(CompletableFuture<Boolean> cb) {
        ApplyTask task = new ApplyTask();
        task.type = TaskType.SNAPSHOT_LOAD;
        task.cb = cb;
        return this.enqueueTask(task);
    }

    public boolean onSnapshotSave(CompletableFuture<Boolean> cb) {
        ApplyTask task = new ApplyTask();
        task.type = TaskType.SNAPSHOT_SAVE;
        task.cb = cb;
        return this.enqueueTask(task);
    }

    public void shutdown() {
        super.shutdown();
        this.statemachine.onShutdown();
    }

    public void run() {
        while (!this.isStopped()) {
            try {
                ApplyTask task = this.taskQueue.poll(5L, TimeUnit.SECONDS);
                if (task == null) continue;
                switch (task.type) {
                    case COMMITTED: {
                        this.doCommitted(task.committedIndex);
                        break;
                    }
                    case SNAPSHOT_SAVE: {
                        this.doSnapshotSave(task.cb);
                        break;
                    }
                    case SNAPSHOT_LOAD: {
                        this.doSnapshotLoad(task.cb);
                    }
                }
            }
            catch (InterruptedException e) {
                logger.error("Error happen in {} when pull task from task queue", (Object)this.getServiceName(), (Object)e);
            }
        }
    }

    private void doCommitted(long committedIndex) {
        long lastAppliedIndex = this.lastAppliedIndex.get();
        if (lastAppliedIndex >= committedIndex) {
            return;
        }
        CommittedEntryIterator iter = new CommittedEntryIterator(this.dLedgerStore, committedIndex, this.applyingIndex, lastAppliedIndex, this.completeEntryCallback);
        while (iter.hasNext()) {
            this.statemachine.onApply(iter);
        }
        long lastIndex = iter.getIndex();
        this.lastAppliedIndex.set(lastIndex);
        DLedgerEntry dLedgerEntry = this.dLedgerStore.get(lastIndex);
        if (dLedgerEntry != null) {
            this.lastAppliedTerm = dLedgerEntry.getTerm();
        }
        if (iter.getCompleteAckNums() == 0 && this.entryPusher != null) {
            this.entryPusher.checkResponseFuturesTimeout(this.lastAppliedIndex.get() + 1L);
        }
    }

    private void doSnapshotLoad(CompletableFuture<Boolean> cb) {
    }

    private void doSnapshotSave(CompletableFuture<Boolean> cb) {
    }

    public String getServiceName() {
        return StateMachineCaller.class.getName();
    }

    public Long getLastAppliedIndex() {
        return this.lastAppliedIndex.get();
    }

    private static class ApplyTask {
        TaskType type;
        long committedIndex;
        long term;
        CompletableFuture<Boolean> cb;

        private ApplyTask() {
        }
    }

    private static enum TaskType {
        COMMITTED,
        SNAPSHOT_SAVE,
        SNAPSHOT_LOAD,
        SHUTDOWN;

    }
}

