/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.utils;

import java.io.File;
import java.text.NumberFormat;
import java.util.Calendar;

public class DLedgerUtils {
    public static void sleep(long sleepMs) {
        try {
            Thread.sleep(sleepMs);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static long elapsed(long start) {
        return System.currentTimeMillis() - start;
    }

    public static String offset2FileName(long offset) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(offset);
    }

    public static long computeEclipseTimeMilliseconds(long beginTime) {
        return System.currentTimeMillis() - beginTime;
    }

    public static boolean isItTimeToDo(String when) {
        String[] whiles = when.split(";");
        if (whiles.length > 0) {
            Calendar now = Calendar.getInstance();
            for (String w : whiles) {
                int nowHour = Integer.parseInt(w);
                if (nowHour != now.get(11)) continue;
                return true;
            }
        }
        return false;
    }

    public static double getDiskPartitionSpaceUsedPercent(String path) {
        if (null == path || path.isEmpty()) {
            return -1.0;
        }
        try {
            File file = new File(path);
            if (!file.exists()) {
                return -1.0;
            }
            long totalSpace = file.getTotalSpace();
            if (totalSpace > 0L) {
                long freeSpace = file.getFreeSpace();
                long usedSpace = totalSpace - freeSpace;
                return (double)usedSpace / (double)totalSpace;
            }
        }
        catch (Exception e) {
            return -1.0;
        }
        return -1.0;
    }
}

