/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger;

import io.openmessaging.storage.dledger.AppendFuture;
import io.openmessaging.storage.dledger.DLedgerConfig;
import io.openmessaging.storage.dledger.DLedgerEntryPusher;
import io.openmessaging.storage.dledger.DLedgerLeaderElector;
import io.openmessaging.storage.dledger.DLedgerRpcNettyService;
import io.openmessaging.storage.dledger.DLedgerRpcService;
import io.openmessaging.storage.dledger.MemberState;
import io.openmessaging.storage.dledger.entry.DLedgerEntry;
import io.openmessaging.storage.dledger.exception.DLedgerException;
import io.openmessaging.storage.dledger.protocol.AppendEntryRequest;
import io.openmessaging.storage.dledger.protocol.AppendEntryResponse;
import io.openmessaging.storage.dledger.protocol.DLedgerProtocolHander;
import io.openmessaging.storage.dledger.protocol.DLedgerResponseCode;
import io.openmessaging.storage.dledger.protocol.GetEntriesRequest;
import io.openmessaging.storage.dledger.protocol.GetEntriesResponse;
import io.openmessaging.storage.dledger.protocol.HeartBeatRequest;
import io.openmessaging.storage.dledger.protocol.HeartBeatResponse;
import io.openmessaging.storage.dledger.protocol.MetadataRequest;
import io.openmessaging.storage.dledger.protocol.MetadataResponse;
import io.openmessaging.storage.dledger.protocol.PullEntriesRequest;
import io.openmessaging.storage.dledger.protocol.PullEntriesResponse;
import io.openmessaging.storage.dledger.protocol.PushEntryRequest;
import io.openmessaging.storage.dledger.protocol.PushEntryResponse;
import io.openmessaging.storage.dledger.protocol.VoteRequest;
import io.openmessaging.storage.dledger.protocol.VoteResponse;
import io.openmessaging.storage.dledger.store.DLedgerMemoryStore;
import io.openmessaging.storage.dledger.store.DLedgerStore;
import io.openmessaging.storage.dledger.store.file.DLedgerMmapFileStore;
import io.openmessaging.storage.dledger.utils.PreConditions;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLedgerServer
implements DLedgerProtocolHander {
    private static Logger logger = LoggerFactory.getLogger(DLedgerServer.class);
    private MemberState memberState;
    private DLedgerConfig dLedgerConfig;
    private DLedgerStore dLedgerStore;
    private DLedgerRpcService dLedgerRpcService;
    private DLedgerEntryPusher dLedgerEntryPusher;
    private DLedgerLeaderElector dLedgerLeaderElector;

    public DLedgerServer(DLedgerConfig dLedgerConfig) {
        this.dLedgerConfig = dLedgerConfig;
        this.memberState = new MemberState(dLedgerConfig);
        this.dLedgerStore = this.createDLedgerStore(dLedgerConfig.getStoreType(), this.dLedgerConfig, this.memberState);
        this.dLedgerRpcService = new DLedgerRpcNettyService(this);
        this.dLedgerEntryPusher = new DLedgerEntryPusher(dLedgerConfig, this.memberState, this.dLedgerStore, this.dLedgerRpcService);
        this.dLedgerLeaderElector = new DLedgerLeaderElector(dLedgerConfig, this.memberState, this.dLedgerRpcService);
    }

    public void startup() {
        this.dLedgerStore.startup();
        this.dLedgerRpcService.startup();
        this.dLedgerEntryPusher.startup();
        this.dLedgerLeaderElector.startup();
    }

    public void shutdown() {
        this.dLedgerLeaderElector.shutdown();
        this.dLedgerEntryPusher.shutdown();
        this.dLedgerRpcService.shutdown();
        this.dLedgerStore.shutdown();
    }

    private DLedgerStore createDLedgerStore(String storeType, DLedgerConfig config, MemberState memberState) {
        if (storeType.equals("MEMORY")) {
            return new DLedgerMemoryStore(config, memberState);
        }
        return new DLedgerMmapFileStore(config, memberState);
    }

    public MemberState getMemberState() {
        return this.memberState;
    }

    @Override
    public CompletableFuture<HeartBeatResponse> handleHeartBeat(HeartBeatRequest request) throws Exception {
        try {
            PreConditions.check(this.memberState.getSelfId().equals(request.getRemoteId()), DLedgerResponseCode.UNKNOWN_MEMBER, "%s != %s", request.getRemoteId(), this.memberState.getSelfId());
            PreConditions.check(this.memberState.getGroup().equals(request.getGroup()), DLedgerResponseCode.UNKNOWN_GROUP, "%s != %s", request.getGroup(), this.memberState.getGroup());
            return this.dLedgerLeaderElector.handleHeartBeat(request);
        }
        catch (DLedgerException e) {
            logger.error("[{}][HandleHeartBeat] failed", (Object)this.memberState.getSelfId(), (Object)e);
            HeartBeatResponse response = new HeartBeatResponse();
            response.copyBaseInfo(request);
            response.setCode(e.getCode().getCode());
            response.setLeaderId(this.memberState.getLeaderId());
            return CompletableFuture.completedFuture(response);
        }
    }

    @Override
    public CompletableFuture<VoteResponse> handleVote(VoteRequest request) throws Exception {
        try {
            PreConditions.check(this.memberState.getSelfId().equals(request.getRemoteId()), DLedgerResponseCode.UNKNOWN_MEMBER, "%s != %s", request.getRemoteId(), this.memberState.getSelfId());
            PreConditions.check(this.memberState.getGroup().equals(request.getGroup()), DLedgerResponseCode.UNKNOWN_GROUP, "%s != %s", request.getGroup(), this.memberState.getGroup());
            return this.dLedgerLeaderElector.handleVote(request, false);
        }
        catch (DLedgerException e) {
            logger.error("[{}][HandleVote] failed", (Object)this.memberState.getSelfId(), (Object)e);
            VoteResponse response = new VoteResponse();
            response.copyBaseInfo(request);
            response.setCode(e.getCode().getCode());
            response.setLeaderId(this.memberState.getLeaderId());
            return CompletableFuture.completedFuture(response);
        }
    }

    @Override
    public CompletableFuture<AppendEntryResponse> handleAppend(AppendEntryRequest request) throws IOException {
        try {
            PreConditions.check(this.memberState.getSelfId().equals(request.getRemoteId()), DLedgerResponseCode.UNKNOWN_MEMBER, "%s != %s", request.getRemoteId(), this.memberState.getSelfId());
            PreConditions.check(this.memberState.getGroup().equals(request.getGroup()), DLedgerResponseCode.UNKNOWN_GROUP, "%s != %s", request.getGroup(), this.memberState.getGroup());
            PreConditions.check(this.memberState.isLeader(), DLedgerResponseCode.NOT_LEADER);
            long currTerm = this.memberState.currTerm();
            if (this.dLedgerEntryPusher.isPendingFull(currTerm)) {
                AppendEntryResponse appendEntryResponse = new AppendEntryResponse();
                appendEntryResponse.setGroup(this.memberState.getGroup());
                appendEntryResponse.setCode(DLedgerResponseCode.LEADER_PENDING_FULL.getCode());
                appendEntryResponse.setTerm(currTerm);
                appendEntryResponse.setLeaderId(this.memberState.getSelfId());
                return AppendFuture.newCompletedFuture(-1L, appendEntryResponse);
            }
            DLedgerEntry dLedgerEntry = new DLedgerEntry();
            dLedgerEntry.setBody(request.getBody());
            DLedgerEntry resEntry = this.dLedgerStore.appendAsLeader(dLedgerEntry);
            return this.dLedgerEntryPusher.waitAck(resEntry);
        }
        catch (DLedgerException e) {
            logger.error("[{}][HandleAppend] failed", (Object)this.memberState.getSelfId(), (Object)e);
            AppendEntryResponse response = new AppendEntryResponse();
            response.copyBaseInfo(request);
            response.setCode(e.getCode().getCode());
            response.setLeaderId(this.memberState.getLeaderId());
            return AppendFuture.newCompletedFuture(-1L, response);
        }
    }

    @Override
    public CompletableFuture<GetEntriesResponse> handleGet(GetEntriesRequest request) throws IOException {
        try {
            PreConditions.check(this.memberState.getSelfId().equals(request.getRemoteId()), DLedgerResponseCode.UNKNOWN_MEMBER, "%s != %s", request.getRemoteId(), this.memberState.getSelfId());
            PreConditions.check(this.memberState.getGroup().equals(request.getGroup()), DLedgerResponseCode.UNKNOWN_GROUP, "%s != %s", request.getGroup(), this.memberState.getGroup());
            PreConditions.check(this.memberState.isLeader(), DLedgerResponseCode.NOT_LEADER);
            DLedgerEntry entry = this.dLedgerStore.get(request.getBeginIndex());
            GetEntriesResponse response = new GetEntriesResponse();
            response.setGroup(this.memberState.getGroup());
            if (entry != null) {
                response.setEntries(Collections.singletonList(entry));
            }
            return CompletableFuture.completedFuture(response);
        }
        catch (DLedgerException e) {
            logger.error("[{}][HandleGet] failed", (Object)this.memberState.getSelfId(), (Object)e);
            GetEntriesResponse response = new GetEntriesResponse();
            response.copyBaseInfo(request);
            response.setLeaderId(this.memberState.getLeaderId());
            response.setCode(e.getCode().getCode());
            return CompletableFuture.completedFuture(response);
        }
    }

    @Override
    public CompletableFuture<MetadataResponse> handleMetadata(MetadataRequest request) throws Exception {
        try {
            PreConditions.check(this.memberState.getSelfId().equals(request.getRemoteId()), DLedgerResponseCode.UNKNOWN_MEMBER, "%s != %s", request.getRemoteId(), this.memberState.getSelfId());
            PreConditions.check(this.memberState.getGroup().equals(request.getGroup()), DLedgerResponseCode.UNKNOWN_GROUP, "%s != %s", request.getGroup(), this.memberState.getGroup());
            MetadataResponse metadataResponse = new MetadataResponse();
            metadataResponse.setGroup(this.memberState.getGroup());
            metadataResponse.setPeers(this.memberState.getPeerMap());
            metadataResponse.setLeaderId(this.memberState.getLeaderId());
            return CompletableFuture.completedFuture(metadataResponse);
        }
        catch (DLedgerException e) {
            logger.error("[{}][HandleMetadata] failed", (Object)this.memberState.getSelfId(), (Object)e);
            MetadataResponse response = new MetadataResponse();
            response.copyBaseInfo(request);
            response.setCode(e.getCode().getCode());
            response.setLeaderId(this.memberState.getLeaderId());
            return CompletableFuture.completedFuture(response);
        }
    }

    @Override
    public CompletableFuture<PullEntriesResponse> handlePull(PullEntriesRequest request) {
        return null;
    }

    @Override
    public CompletableFuture<PushEntryResponse> handlePush(PushEntryRequest request) throws Exception {
        try {
            PreConditions.check(this.memberState.getSelfId().equals(request.getRemoteId()), DLedgerResponseCode.UNKNOWN_MEMBER, "%s != %s", request.getRemoteId(), this.memberState.getSelfId());
            PreConditions.check(this.memberState.getGroup().equals(request.getGroup()), DLedgerResponseCode.UNKNOWN_GROUP, "%s != %s", request.getGroup(), this.memberState.getGroup());
            return this.dLedgerEntryPusher.handlePush(request);
        }
        catch (DLedgerException e) {
            logger.error("[{}][HandlePush] failed", (Object)this.memberState.getSelfId(), (Object)e);
            PushEntryResponse response = new PushEntryResponse();
            response.copyBaseInfo(request);
            response.setCode(e.getCode().getCode());
            response.setLeaderId(this.memberState.getLeaderId());
            return CompletableFuture.completedFuture(response);
        }
    }

    public DLedgerStore getdLedgerStore() {
        return this.dLedgerStore;
    }

    public DLedgerRpcService getdLedgerRpcService() {
        return this.dLedgerRpcService;
    }

    public DLedgerLeaderElector getdLedgerLeaderElector() {
        return this.dLedgerLeaderElector;
    }

    public DLedgerConfig getdLedgerConfig() {
        return this.dLedgerConfig;
    }
}

