/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.shade.com.fasterxml.jackson.module.blackbird.deser;

import io.openlineage.spark.shade.com.fasterxml.jackson.core.JsonParser;
import io.openlineage.spark.shade.com.fasterxml.jackson.databind.DeserializationContext;
import io.openlineage.spark.shade.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import io.openlineage.spark.shade.com.fasterxml.jackson.module.blackbird.deser.OptimizedSettableBeanProperty;
import java.io.IOException;
import java.util.function.ObjLongConsumer;

final class SettableLongProperty
extends OptimizedSettableBeanProperty<SettableLongProperty> {
    private static final long serialVersionUID = 1L;
    private ObjLongConsumer<Object> _optimizedSetter;

    public SettableLongProperty(SettableBeanProperty src, ObjLongConsumer<Object> optimizedSetter) {
        super(src);
        this._optimizedSetter = optimizedSetter;
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableLongProperty(del, this._optimizedSetter);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        if (!p.isExpectedNumberIntToken()) {
            this.delegate.deserializeAndSet(p, ctxt, bean);
            return;
        }
        long v = p.getLongValue();
        try {
            this._optimizedSetter.accept(bean, v);
        }
        catch (Throwable e) {
            this._reportProblem(bean, v, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        if (p.isExpectedNumberIntToken()) {
            return this.setAndReturn(instance, p.getLongValue());
        }
        return this.delegate.deserializeSetAndReturn(p, ctxt, instance);
    }

    @Override
    public void set(Object bean, Object value) throws IOException {
        long v = ((Number)value).longValue();
        try {
            this._optimizedSetter.accept(bean, v);
        }
        catch (Throwable e) {
            this._reportProblem(bean, v, e);
        }
    }
}

