/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.utils;

import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenProjectUtil {
    public static String getPluginConfiguration(MavenProject proj, String pluginGroupId, String pluginArtifactId, String key) {
        return MavenProjectUtil.getPluginExecutionConfiguration(proj, pluginGroupId, pluginArtifactId, null, key);
    }

    public static String getPluginExecutionConfiguration(MavenProject proj, String pluginGroupId, String pluginArtifactId, String executionId, String key) {
        Xpp3Dom val;
        Xpp3Dom dom = proj.getGoalConfiguration(pluginGroupId, pluginArtifactId, executionId, null);
        if (dom != null && (val = dom.getChild(key)) != null) {
            return val.getValue();
        }
        return null;
    }

    public static Map<String, String> getWebResourcesConfiguration(MavenProject proj) {
        Xpp3Dom[] resources;
        Xpp3Dom web;
        Xpp3Dom dom = proj.getGoalConfiguration("org.apache.maven.plugins", "maven-war-plugin", null, null);
        if (dom != null && (web = dom.getChild("webResources")) != null && (resources = web.getChildren("resource")) != null) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (int i = 0; i < resources.length; ++i) {
                Xpp3Dom dir = resources[i].getChild("directory");
                if (dir == null) continue;
                Xpp3Dom target = resources[i].getChild("targetPath");
                if (target != null) {
                    result.put(dir.getValue(), target.getValue());
                    continue;
                }
                result.put(dir.getValue(), null);
            }
            return result;
        }
        return null;
    }

    public static String getPluginGoalConfigurationString(MavenProject project, String pluginKey, String goal, String configName) throws PluginScenarioException {
        Xpp3Dom configElement;
        PluginExecution execution = MavenProjectUtil.getPluginGoalExecution(project, pluginKey, goal);
        Xpp3Dom config = (Xpp3Dom)execution.getConfiguration();
        if (config != null && (configElement = config.getChild(configName)) != null) {
            String value = configElement.getValue().trim();
            return value;
        }
        throw new PluginScenarioException("Could not find configuration string " + configName + " for goal " + goal + " on plugin " + pluginKey);
    }

    public static PluginExecution getPluginGoalExecution(Plugin plugin, String goal) throws PluginScenarioException {
        List executions = plugin.getExecutions();
        for (PluginExecution execution : executions) {
            if (!execution.getGoals().contains(goal)) continue;
            return execution;
        }
        throw new PluginScenarioException("Could not find goal " + goal + " on plugin " + plugin.getKey());
    }

    public static PluginExecution getPluginGoalExecution(MavenProject project, String pluginKey, String goal) throws PluginScenarioException {
        Plugin plugin = project.getPlugin(pluginKey);
        return MavenProjectUtil.getPluginGoalExecution(plugin, goal);
    }

    public static File getManifestFile(MavenProject proj, String pluginArtifactId) {
        Xpp3Dom val;
        Xpp3Dom archive;
        Xpp3Dom dom = proj.getGoalConfiguration("org.apache.maven.plugins", pluginArtifactId, null, null);
        if (dom != null && (archive = dom.getChild("archive")) != null && (val = archive.getChild("manifestFile")) != null) {
            return new File(proj.getBasedir().getAbsolutePath() + "/" + val.getValue());
        }
        return null;
    }

    public static int getMajorPluginVersion(MavenProject project, String pluginKey) throws PluginScenarioException {
        Plugin plugin = project.getPlugin(pluginKey);
        return Character.getNumericValue(plugin.getVersion().charAt(0));
    }
}

