/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.maven.server.StartDebugMojoSupport;
import java.text.MessageFormat;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="start")
public class StartServerMojo
extends StartDebugMojoSupport {
    @Parameter(property="verifyTimeout", defaultValue="30")
    private int verifyTimeout = 30;
    @Parameter(property="serverStartTimeout", defaultValue="30")
    private int serverStartTimeout = 30;
    @Parameter(property="applications")
    private String applications;
    @Parameter(property="clean", defaultValue="false")
    protected boolean clean;
    @Parameter(property="embedded", defaultValue="false")
    private boolean embedded;

    protected void doExecute() throws Exception {
        if (this.skip) {
            return;
        }
        if (this.isInstall) {
            this.installServerAssembly();
        } else {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.type.preexisting"), ""));
            this.checkServerHomeExists();
        }
        ServerTask serverTask = this.initializeJava();
        this.copyConfigFiles();
        serverTask.setUseEmbeddedServer(this.embedded);
        serverTask.setClean(this.clean);
        serverTask.setOperation("start");
        if (this.serverStartTimeout < 0) {
            this.serverStartTimeout = 30;
        }
        serverTask.setTimeout(Long.toString(this.serverStartTimeout * 1000));
        serverTask.execute();
        if (this.verifyTimeout < 0) {
            this.verifyTimeout = 30;
        }
        long timeout = this.verifyTimeout * 1000;
        long endTime = System.currentTimeMillis() + timeout;
        if (this.applications != null) {
            String[] apps;
            for (String archiveName : apps = this.applications.split("[,\\s]+")) {
                String startMessage = serverTask.waitForStringInLog("CWWKZ0001I.*" + archiveName, timeout, serverTask.getLogFile());
                if (startMessage == null) {
                    this.stopServer();
                    throw new MojoExecutionException(MessageFormat.format(messages.getString("error.server.start.verify"), this.verifyTimeout));
                }
                timeout = endTime - System.currentTimeMillis();
            }
        }
    }

    private void stopServer() {
        try {
            ServerTask serverTask = this.initializeJava();
            serverTask.setOperation("stop");
            serverTask.execute();
        }
        catch (Exception e) {
            this.log.debug((CharSequence)"Error stopping server", (Throwable)e);
        }
    }
}

