/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.common.plugins.config.ServerConfigDropinXmlDocument;
import io.openliberty.tools.maven.BasicSupport;
import io.openliberty.tools.maven.utils.ExecuteMojoUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class StartDebugMojoSupport
extends BasicSupport {
    private static final String LIBERTY_MAVEN_PLUGIN_GROUP_ID = "io.openliberty.tools";
    private static final String LIBERTY_MAVEN_PLUGIN_ARTIFACT_ID = "liberty-maven-plugin";
    private static final String HEADER = "# Generated by liberty-maven-plugin";
    private static final String LIBERTY_CONFIG_MAVEN_PROPS = "(^liberty\\.(env|jvm|bootstrap|var|defaultVar)\\.).+";
    private static final Pattern pattern = Pattern.compile("(^liberty\\.(env|jvm|bootstrap|var|defaultVar)\\.).+");
    protected final String PLUGIN_VARIABLE_CONFIG_XML = "configDropins/overrides/liberty-plugin-variable-config.xml";
    protected Map<String, String> bootstrapMavenProps = new HashMap<String, String>();
    protected Map<String, String> envMavenProps = new HashMap<String, String>();
    protected List<String> jvmMavenProps = new ArrayList<String>();
    protected Map<String, String> varMavenProps = new HashMap<String, String>();
    protected Map<String, String> defaultVarMavenProps = new HashMap<String, String>();
    protected Map<String, String> combinedBootstrapProperties = null;
    protected List<String> combinedJvmOptions = null;
    @Component
    protected BuildPluginManager pluginManager;
    @Parameter(alias="configFile", property="serverXmlFile")
    protected File serverXmlFile;
    @Parameter(property="bootstrapPropertiesFile")
    protected File bootstrapPropertiesFile;
    @Parameter
    protected Map<String, String> bootstrapProperties;
    @Parameter(property="jvmOptionsFile")
    protected File jvmOptionsFile;
    @Parameter
    protected List<String> jvmOptions;

    protected ServerTask initializeJava() {
        ServerTask serverTask = (ServerTask)this.ant.createTask("antlib:io/openliberty/tools/ant:server");
        if (serverTask == null) {
            throw new IllegalStateException(MessageFormat.format(messages.getString("error.dependencies.not.found"), "server"));
        }
        serverTask.setInstallDir(this.installDirectory);
        serverTask.setServerName(this.serverName);
        serverTask.setUserDir(this.userDirectory);
        serverTask.setOutputDir(this.outputDirectory);
        return serverTask;
    }

    protected void runMojo(String groupId, String artifactId, String goal) throws MojoExecutionException {
        Plugin plugin = this.getPlugin(groupId, artifactId);
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(plugin, goal, this.log);
        this.log.info((CharSequence)("Running " + artifactId + ":" + goal));
        this.log.debug((CharSequence)("configuration:\n" + config));
        MojoExecutor.executeMojo((Plugin)plugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)config, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    protected Plugin getPlugin(String groupId, String artifactId) {
        Plugin plugin = this.project.getPlugin(groupId + ":" + artifactId);
        if (plugin == null) {
            plugin = MojoExecutor.plugin((String)MojoExecutor.groupId((String)groupId), (String)MojoExecutor.artifactId((String)artifactId), (String)MojoExecutor.version((String)"RELEASE"));
        }
        return plugin;
    }

    protected Plugin getLibertyPlugin() {
        Plugin plugin = this.project.getPlugin("io.openliberty.tools:liberty-maven-plugin");
        if (plugin == null) {
            plugin = MojoExecutor.plugin((String)LIBERTY_MAVEN_PLUGIN_GROUP_ID, (String)LIBERTY_MAVEN_PLUGIN_ARTIFACT_ID, (String)"LATEST");
        }
        return plugin;
    }

    protected void runLibertyMojoCreate() throws MojoExecutionException {
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(this.getLibertyPlugin(), "create", this.log);
        this.runLibertyMojo("create", config);
    }

    protected void runLibertyMojoDeploy() throws MojoExecutionException {
        this.runLibertyMojoDeploy(true);
    }

    protected void runLibertyMojoDeploy(boolean forceLooseApp) throws MojoExecutionException {
        Xpp3Dom looseApp;
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(this.getLibertyPlugin(), "deploy", this.log);
        if (forceLooseApp && (looseApp = config.getChild("looseApplication")) != null && "false".equals(looseApp.getValue())) {
            this.log.warn((CharSequence)"Overriding liberty plugin pararmeter, \"looseApplication\" to \"true\" and deploying application in looseApplication format");
            looseApp.setValue("true");
        }
        this.runLibertyMojo("deploy", config);
    }

    protected void runLibertyMojoInstallFeature(MojoExecutor.Element features) throws MojoExecutionException {
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(this.getLibertyPlugin(), "install-feature", this.log);
        if (features != null) {
            config = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{features}), (Xpp3Dom)config);
        }
        this.runLibertyMojo("install-feature", config);
    }

    private void runLibertyMojo(String goal, Xpp3Dom config) throws MojoExecutionException {
        this.log.info((CharSequence)("Running liberty:" + goal));
        this.log.debug((CharSequence)("configuration:\n" + config));
        MojoExecutor.executeMojo((Plugin)this.getLibertyPlugin(), (String)MojoExecutor.goal((String)goal), (Xpp3Dom)config, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    protected void copyConfigFiles() throws Exception {
        String jvmOptionsPath = null;
        String bootStrapPropertiesPath = null;
        String serverEnvPath = null;
        String serverXMLPath = null;
        this.loadLibertyConfigFromProperties();
        if (this.configDirectory != null && this.configDirectory.exists()) {
            File configDirServerEnv;
            File configDirBootstrapFile;
            File configDirJvmOptionsFile;
            Copy copydir = (Copy)this.ant.createTask("copy");
            FileSet fileset = new FileSet();
            fileset.setDir(this.configDirectory);
            copydir.addFileset(fileset);
            copydir.setTodir(this.serverDirectory);
            copydir.setOverwrite(true);
            copydir.execute();
            File configDirServerXML = new File(this.configDirectory, "server.xml");
            if (configDirServerXML.exists()) {
                serverXMLPath = configDirServerXML.getCanonicalPath();
            }
            if ((configDirJvmOptionsFile = new File(this.configDirectory, "jvm.options")).exists()) {
                jvmOptionsPath = configDirJvmOptionsFile.getCanonicalPath();
            }
            if ((configDirBootstrapFile = new File(this.configDirectory, "bootstrap.properties")).exists()) {
                bootStrapPropertiesPath = configDirBootstrapFile.getCanonicalPath();
            }
            if ((configDirServerEnv = new File(this.configDirectory, "server.env")).exists()) {
                serverEnvPath = configDirServerEnv.getCanonicalPath();
            }
        }
        if (this.serverXmlFile != null && this.serverXmlFile.exists()) {
            if (serverXMLPath != null) {
                this.log.warn((CharSequence)("The " + serverXMLPath + " file is overwritten by the " + this.serverXmlFile.getCanonicalPath() + " file."));
            }
            Copy copy = (Copy)this.ant.createTask("copy");
            copy.setFile(this.serverXmlFile);
            copy.setTofile(new File(this.serverDirectory, "server.xml"));
            copy.setOverwrite(true);
            copy.execute();
            serverXMLPath = this.serverXmlFile.getCanonicalPath();
        }
        File optionsFile = new File(this.serverDirectory, "jvm.options");
        if (this.jvmOptions != null || !this.jvmMavenProps.isEmpty()) {
            if (jvmOptionsPath != null) {
                this.log.warn((CharSequence)("The " + jvmOptionsPath + " file is overwritten by inlined configuration."));
            }
            this.writeJvmOptions(optionsFile, this.jvmOptions, this.jvmMavenProps);
            jvmOptionsPath = "inlined configuration";
        } else if (this.jvmOptionsFile != null && this.jvmOptionsFile.exists()) {
            if (jvmOptionsPath != null) {
                this.log.warn((CharSequence)("The " + jvmOptionsPath + " file is overwritten by the " + this.jvmOptionsFile.getCanonicalPath() + " file."));
            }
            Copy copy = (Copy)this.ant.createTask("copy");
            copy.setFile(this.jvmOptionsFile);
            copy.setTofile(optionsFile);
            copy.setOverwrite(true);
            copy.execute();
            jvmOptionsPath = this.jvmOptionsFile.getCanonicalPath();
        }
        File bootstrapFile = new File(this.serverDirectory, "bootstrap.properties");
        if (this.bootstrapProperties != null || !this.bootstrapMavenProps.isEmpty()) {
            if (bootStrapPropertiesPath != null) {
                this.log.warn((CharSequence)("The " + bootStrapPropertiesPath + " file is overwritten by inlined configuration."));
            }
            this.writeBootstrapProperties(bootstrapFile, this.bootstrapProperties, this.bootstrapMavenProps);
            bootStrapPropertiesPath = "inlined configuration";
        } else if (this.bootstrapPropertiesFile != null && this.bootstrapPropertiesFile.exists()) {
            if (bootStrapPropertiesPath != null) {
                this.log.warn((CharSequence)("The " + bootStrapPropertiesPath + " file is overwritten by the " + this.bootstrapPropertiesFile.getCanonicalPath() + " file."));
            }
            Copy copy = (Copy)this.ant.createTask("copy");
            copy.setFile(this.bootstrapPropertiesFile);
            copy.setTofile(bootstrapFile);
            copy.setOverwrite(true);
            copy.execute();
            bootStrapPropertiesPath = this.bootstrapPropertiesFile.getCanonicalPath();
        }
        File envFile = new File(this.serverDirectory, "server.env");
        if (!this.envMavenProps.isEmpty()) {
            if (serverEnvPath != null) {
                this.log.warn((CharSequence)("The " + serverEnvPath + " file is overwritten by inlined configuration."));
            }
            this.writeServerEnvProperties(envFile, this.envMavenProps);
            serverEnvPath = "inlined configuration";
        } else if (this.serverEnvFile != null && this.serverEnvFile.exists()) {
            Copy copy = (Copy)this.ant.createTask("copy");
            copy.setFile(this.serverEnvFile);
            copy.setTofile(envFile);
            copy.setOverwrite(true);
            copy.execute();
            serverEnvPath = this.serverEnvFile.getCanonicalPath();
        }
        if (!this.varMavenProps.isEmpty() || !this.defaultVarMavenProps.isEmpty()) {
            File pluginVariableConfig = new File(this.serverDirectory, "configDropins/overrides/liberty-plugin-variable-config.xml");
            this.writeConfigDropinsServerVariables(pluginVariableConfig, this.varMavenProps, this.defaultVarMavenProps);
        }
        if (serverXMLPath != null && !serverXMLPath.isEmpty()) {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "server.xml", serverXMLPath));
        }
        if (jvmOptionsPath != null && !jvmOptionsPath.isEmpty()) {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "jvm.options", jvmOptionsPath));
        }
        if (bootStrapPropertiesPath != null && !bootStrapPropertiesPath.isEmpty()) {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "bootstrap.properties", bootStrapPropertiesPath));
        }
        if (serverEnvPath != null && !serverEnvPath.isEmpty()) {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.start.update.config"), "server.env", serverEnvPath));
        }
    }

    private void loadLibertyConfigFromProperties() {
        this.loadLibertyConfigFromProperties(this.project.getProperties());
        this.loadLibertyConfigFromProperties(System.getProperties());
    }

    private void loadLibertyConfigFromProperties(Properties props) {
        Set<Map.Entry<Object, Object>> entries = props.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            String key = (String)entry.getKey();
            PropertyType propType = PropertyType.getPropertyType(key);
            if (propType == null) continue;
            String suffix = key.substring(propType.getPrefix().length());
            String value = (String)entry.getValue();
            this.log.debug((CharSequence)("Processing Liberty configuration from property with key " + key + " and value " + value));
            switch (propType) {
                case ENV: {
                    this.envMavenProps.put(suffix, value);
                    break;
                }
                case BOOTSTRAP: {
                    this.bootstrapMavenProps.put(suffix, value);
                    break;
                }
                case JVM: {
                    this.jvmMavenProps.add(value);
                    break;
                }
                case VAR: {
                    this.varMavenProps.put(suffix, value);
                    break;
                }
                case DEFAULTVAR: {
                    this.defaultVarMavenProps.put(suffix, value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBootstrapProperties(File file, Map<String, String> properties, Map<String, String> mavenProperties) throws IOException {
        if (!mavenProperties.isEmpty()) {
            if (properties == null) {
                this.combinedBootstrapProperties = mavenProperties;
            } else {
                this.combinedBootstrapProperties = new HashMap<String, String>();
                this.combinedBootstrapProperties.putAll(mavenProperties);
                this.combinedBootstrapProperties.putAll(properties);
            }
        } else {
            this.combinedBootstrapProperties = properties;
        }
        this.makeParentDirectory(file);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(file, "UTF-8");
            writer.println(HEADER);
            for (Map.Entry<String, String> entry : this.combinedBootstrapProperties.entrySet()) {
                String key = entry.getKey();
                writer.print(key);
                writer.print("=");
                String value = entry.getValue();
                writer.println(value != null ? value.replace("\\", "/") : "");
                if (value != null) continue;
                this.log.warn((CharSequence)("The value of the bootstrap property " + key + " is null. Verify if the needed POM properties are set correctly."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeServerEnvProperties(File file, Map<String, String> mavenProperties) throws IOException {
        this.makeParentDirectory(file);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(file, "UTF-8");
            writer.println(HEADER);
            for (Map.Entry<String, String> entry : mavenProperties.entrySet()) {
                String key = entry.getKey();
                writer.print(key);
                writer.print("=");
                String value = entry.getValue();
                writer.println(value != null ? value.replace("\\", "/") : "");
                if (value != null) continue;
                this.log.warn((CharSequence)("The value of the server.env property " + entry.getKey() + " is null. Verify if the needed POM properties are set correctly."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJvmOptions(File file, List<String> options, List<String> mavenProperties) throws IOException {
        if (!mavenProperties.isEmpty()) {
            if (options == null) {
                this.combinedJvmOptions = mavenProperties;
            } else {
                this.combinedJvmOptions = new ArrayList<String>();
                this.combinedJvmOptions.addAll(mavenProperties);
                this.combinedJvmOptions.addAll(options);
            }
        } else {
            this.combinedJvmOptions = options;
        }
        this.makeParentDirectory(file);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(file, "UTF-8");
            writer.println(HEADER);
            for (String option : this.combinedJvmOptions) {
                writer.println(option);
            }
        }
    }

    private void writeConfigDropinsServerVariables(File file, Map<String, String> varMavenProps, Map<String, String> defaultVarMavenProps) throws IOException, TransformerException, ParserConfigurationException {
        String key;
        ServerConfigDropinXmlDocument configDocument = ServerConfigDropinXmlDocument.newInstance();
        configDocument.createComment(HEADER);
        HashSet<String> existingVarNames = new HashSet<String>();
        for (Map.Entry<String, String> entry : varMavenProps.entrySet()) {
            key = entry.getKey();
            existingVarNames.add(key);
            configDocument.createVariableWithValue(entry.getKey(), entry.getValue(), false);
        }
        for (Map.Entry<String, String> entry : defaultVarMavenProps.entrySet()) {
            key = entry.getKey();
            if (existingVarNames.contains(key)) {
                this.log.warn((CharSequence)("The variable with name " + key + " and defaultValue " + entry.getValue() + " is skipped since a variable with that name already exists with a value."));
                continue;
            }
            configDocument.createVariableWithValue(entry.getKey(), entry.getValue(), true);
        }
        this.makeParentDirectory(file);
        configDocument.writeXMLDocument(file);
    }

    private void makeParentDirectory(File file) {
        File parentDir = file.getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
    }

    private static enum PropertyType {
        BOOTSTRAP("liberty.bootstrap."),
        ENV("liberty.env."),
        JVM("liberty.jvm."),
        VAR("liberty.var."),
        DEFAULTVAR("liberty.defaultVar.");

        private final String prefix;
        private static final Map<String, PropertyType> lookup;

        private PropertyType(String prefix) {
            this.prefix = prefix;
        }

        public static PropertyType getPropertyType(String propertyName) {
            Matcher matcher = pattern.matcher(propertyName);
            if (matcher.find()) {
                String prefix = matcher.group(1);
                return lookup.get(prefix);
            }
            return null;
        }

        public String getPrefix() {
            return this.prefix;
        }

        static {
            lookup = new HashMap<String, PropertyType>();
            for (PropertyType s : EnumSet.allOf(PropertyType.class)) {
                lookup.put(s.prefix, s);
            }
        }
    }
}

