/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;

class SSLHandshakeErrorTracker {
    private static final TraceComponent tc = Tr.register(SSLHandshakeErrorTracker.class, (String)"SSLChannel", (String)"com.ibm.ws.channel.ssl.internal.resources.SSLChannelMessages");
    private final boolean shouldLogError;
    private final long maxLogEntries;
    private long numberOfLogEntries = 0L;
    private boolean loggingStopped = false;

    SSLHandshakeErrorTracker(boolean shouldLogError, long maxLogEntries) {
        this.shouldLogError = shouldLogError;
        this.maxLogEntries = maxLogEntries;
    }

    void noteHandshakeError(Exception failure) {
        ++this.numberOfLogEntries;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("noteHandshakeError (" + this.numberOfLogEntries + "): " + failure.getMessage()), (Object[])new Object[]{failure});
        }
        if (this.shouldLogError) {
            if (this.numberOfLogEntries <= this.maxLogEntries) {
                Tr.error((TraceComponent)tc, (String)"handshake.failure", (Object[])new Object[]{failure});
            } else if (!this.loggingStopped && this.numberOfLogEntries > this.maxLogEntries) {
                this.loggingStopped = true;
                Tr.info((TraceComponent)tc, (String)"handshake.failure.stop.logging", (Object[])new Object[0]);
            }
        }
    }
}

