/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util.concurrent;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.yoko.util.Fifa;
import org.apache.yoko.util.Fifo;
import org.apache.yoko.util.Sequential;
import org.apache.yoko.util.concurrent.Foot;
import org.apache.yoko.util.concurrent.Head;
import org.apache.yoko.util.concurrent.NNode;
import org.apache.yoko.util.concurrent.PNode;
import org.apache.yoko.util.concurrent.StrongNode;
import org.apache.yoko.util.concurrent.VNode;

class ConcurrentFifo<T>
implements Fifo<T>,
Fifa<T> {
    final Head<T> head = new Head();
    final Foot<T> foot = new Foot<T>(this.head);
    protected final AtomicInteger size = new AtomicInteger(0);

    ConcurrentFifo() {
    }

    @Override
    public int size() {
        return this.size.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T peek() {
        Head<T> head = this.head;
        synchronized (head) {
            NNode<T> n = this.head.next();
            return n == this.foot ? null : (T)((VNode)n).get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Sequential.Place<T> put(T elem) {
        Objects.requireNonNull(elem);
        while (true) {
            PNode<T> prev;
            PNode<T> pNode = prev = this.foot.prev();
            synchronized (pNode) {
                if (prev.next() == this.foot) {
                    VNode<T> node;
                    VNode<T> vNode = node = this.createNode(elem);
                    synchronized (vNode) {
                        node.insertAfter(prev);
                        this.size.incrementAndGet();
                        return new Sequential.Place<T>(){

                            @Override
                            public T relinquish() {
                                return ConcurrentFifo.this.remove(node);
                            }
                        };
                    }
                }
            }
        }
    }

    protected VNode<T> createNode(T elem) {
        return new StrongNode<T>(Objects.requireNonNull(elem));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove() {
        Head<T> head = this.head;
        synchronized (head) {
            NNode<T> n = this.head.next();
            return n == this.foot ? null : (T)this.remove0((VNode)n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T remove(VNode<T> node) {
        PNode prev;
        while ((prev = node.prev()) != null) {
            PNode pNode = prev;
            synchronized (pNode) {
                if (prev.next() == node) {
                    return this.remove0(node);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T remove0(VNode<T> node) {
        assert (Thread.holdsLock(node.prev()));
        VNode<T> vNode = node;
        synchronized (vNode) {
            node.delete();
            this.size.decrementAndGet();
        }
        return node.get();
    }
}

