/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.java2sec;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.java2sec.FilePathUtil;
import com.ibm.ws.classloading.java2sec.GrantEntry;
import com.ibm.ws.classloading.java2sec.Parser;
import com.ibm.ws.classloading.java2sec.ParserException;
import com.ibm.ws.classloading.java2sec.PermissionEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ParseJavaPolicy {
    private static final TraceComponent tc = Tr.register(ParseJavaPolicy.class, (String)"Java2SecurityUtil", (String)"com.ibm.ws.classloading.internal.resources.Java2SecurityUtilMessages");
    String file;
    FileReader fr;
    Parser parser;
    boolean expandProp;
    String keyStoreUrlString;
    String keyStoreType;
    static List<GrantEntry> grants = new ArrayList<GrantEntry>();
    static final long serialVersionUID = 8927841951385111238L;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ParseJavaPolicy(boolean expandProp) throws FileNotFoundException, IOException, ParserException {
        block26: {
            super();
            this.file = null;
            this.fr = null;
            this.parser = null;
            this.expandProp = false;
            try {
                this.file = System.getProperty("java.security.policy");
                if (this.file != null || (javaHome = System.getProperty("java.home")) == null) ** GOTO lbl-1000
                if (!javaHome.endsWith("jre")) ** GOTO lbl-1000
                this.file = javaHome.concat("/lib/security/java.policy");
                fileToCheck = new File(this.file);
                if (!fileToCheck.exists()) {
                    javaHomeWithoutJre = javaHome.substring(0, javaHome.length() - 3);
                    this.file = javaHomeWithoutJre.concat("/lib/security/java.policy");
                    if (!fileToCheck.exists()) {
                        if (ParseJavaPolicy.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)ParseJavaPolicy.tc, (String)("javaHome: " + javaHome + "Could not find java.policy file under either java.home/jre/lib/security or java.home/lib/security"), (Object[])new Object[0]);
                        }
                    }
                }
                ** GOTO lbl-1000
            }
            catch (ParserException e) {
                try {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"125", (Object)this, (Object[])new Object[]{expandProp});
                    throw e;
                    catch (FileNotFoundException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"127", (Object)this, (Object[])new Object[]{expandProp});
                        throw e;
                    }
                    catch (IOException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"129", (Object)this, (Object[])new Object[]{expandProp});
                        throw e;
                    }
                }
                catch (Throwable var6_13) {
                    try {
                        if (this.fr == null) throw var6_13;
                        this.fr.close();
                        throw var6_13;
                    }
                    catch (IOException var7_14) {
                        FFDCFilter.processException((Throwable)var7_14, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"137", (Object)this, (Object[])new Object[]{expandProp});
                        throw e;
                    }
                }
            }
            try {
                if (this.fr == null) return;
                this.fr.close();
                return;
            }
            catch (IOException var5_12) {
                FFDCFilter.processException((Throwable)var5_12, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"137", (Object)this, (Object[])new Object[]{expandProp});
                throw e;
            }
lbl-1000:
            // 1 sources

            {
                this.file = javaHome.concat("/lib/security.java.policy");
                fileToCheck = new File(this.file);
                if (fileToCheck.exists()) ** GOTO lbl-1000
                this.file = javaHome.concat("/jre/lib/security/java.policy");
                fileToCheck = new File(this.file);
                if (fileToCheck.exists()) ** GOTO lbl-1000
                if (!ParseJavaPolicy.tc.isDebugEnabled()) break block26;
                Tr.debug((TraceComponent)ParseJavaPolicy.tc, (String)("javaHome: " + javaHome + "Could not find java.policy file under either java.home/jre/lib/security or java.home/lib/security"), (Object[])new Object[0]);
            }
        }
        try {
            if (this.fr == null) return;
            this.fr.close();
            return;
        }
        catch (IOException javaHomeWithoutJre) {
            FFDCFilter.processException((Throwable)javaHomeWithoutJre, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"137", (Object)this, (Object[])new Object[]{expandProp});
            throw e;
        }
lbl-1000:
        // 4 sources

        {
            if (this.file != null && this.file.charAt(0) == '=') {
                this.file = this.file.substring(1);
            }
            if (this.file != null) ** GOTO lbl-1000
        }
        try {
            if (this.fr == null) return;
            this.fr.close();
            return;
        }
        catch (IOException javaHome) {
            FFDCFilter.processException((Throwable)javaHome, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"137", (Object)this, (Object[])new Object[]{expandProp});
            throw e;
        }
lbl-1000:
        // 1 sources

        {
            fileToCheck = new File(this.file);
            if (fileToCheck.exists()) ** GOTO lbl-1000
        }
        try {
            if (this.fr == null) return;
            this.fr.close();
            return;
        }
        catch (IOException fileToCheck) {
            FFDCFilter.processException((Throwable)fileToCheck, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"137", (Object)this, (Object[])new Object[]{expandProp});
            throw e;
        }
lbl-1000:
        // 1 sources

        {
            this.fr = new FileReader(this.file);
            this.init(this.fr, expandProp);
            this.parse();
        }
        try {
            if (this.fr == null) return;
            this.fr.close();
            return;
        }
        catch (IOException fileToCheck) {
            FFDCFilter.processException((Throwable)fileToCheck, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"137", (Object)this, (Object[])new Object[]{expandProp});
            throw e;
        }
    }

    public static List getJavaPolicyGrants() {
        return grants;
    }

    private void init(Reader rdr, boolean expandProp) {
        this.parser = new Parser(rdr);
        this.expandProp = expandProp;
    }

    public String toString() {
        return this.getClass().getName();
    }

    Iterator grantEntries() {
        return grants.iterator();
    }

    void parse() throws IOException, ParserException {
        this.parser.nextToken();
        while (!this.parser.eof()) {
            if (this.parser.peek("grant")) {
                GrantEntry g = this.parseGrantEntry();
                if (g != null) {
                    grants.add(g);
                }
            } else if (this.parser.peek("keystore")) {
                if (this.keyStoreUrlString == null) {
                    this.parseKeystoreEntry();
                    if (this.keyStoreType == null) {
                        this.keyStoreType = "JKS";
                    }
                }
            } else {
                throw new ParserException(this.parser.getLineNumber(), "Unexpected keyword \"" + this.parser.getStringValue() + "\"");
            }
            this.parser.match(";");
        }
    }

    void parseKeystoreEntry() throws IOException, ParserException {
        this.parser.match("keystore");
        this.keyStoreUrlString = this.parser.match("quoted string");
        if (!this.parser.peek(",")) {
            return;
        }
        this.parser.match(",");
        if (!this.parser.peek("\"")) {
            throw new ParserException(this.parser.getLineNumber(), "expected keystore type");
        }
        this.keyStoreType = this.parser.match("quoted string");
    }

    GrantEntry parseGrantEntry() throws IOException, ParserException {
        String filePrefix = "file:";
        GrantEntry g = new GrantEntry();
        this.parser.match("grant");
        while (!this.parser.peek("{")) {
            if (this.parser.peek("codeBase")) {
                this.parser.match("codeBase");
                g.codeBase = this.parser.match("quoted string");
                if (g.codeBase.startsWith(filePrefix)) {
                    g.codeBase = g.codeBase.substring(filePrefix.length());
                }
                if (!this.parser.peek(",")) continue;
                this.parser.match(",");
                continue;
            }
            if (this.parser.peek("signedBy")) {
                this.parser.match("signedBy");
                g.signedBy = this.parser.match("quoted string");
                if (!this.parser.peek(",")) continue;
                this.parser.match(",");
                continue;
            }
            throw new ParserException(this.parser.getLineNumber(), "expected codeBase or signedBy");
        }
        this.parser.match("{");
        while (!this.parser.peek("}")) {
            if (this.parser.peek("permission")) {
                try {
                    PermissionEntry p = this.parsePermissionEntry();
                    g.add(p);
                }
                catch (ParserException p) {
                    FFDCFilter.processException((Throwable)p, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"281", (Object)this, (Object[])new Object[0]);
                    this.parser.skipEntry();
                }
                this.parser.match(";");
                continue;
            }
            throw new ParserException(this.parser.getLineNumber(), "expected permission entry");
        }
        this.parser.match("}");
        try {
            if (g.codeBase != null) {
                g.codeBase = this.expand(g.codeBase, false);
            }
            g.signedBy = this.expand(g.signedBy);
        }
        catch (ParserException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"295", (Object)this, (Object[])new Object[0]);
            return null;
        }
        return g;
    }

    PermissionEntry parsePermissionEntry() throws IOException, ParserException {
        PermissionEntry p = new PermissionEntry();
        this.parser.match("permission");
        p.permissionType = this.parser.match("permission type");
        if (this.parser.peek("\"")) {
            p.name = this.expand(this.parser.match_p("quoted string")).trim();
        }
        if (!this.parser.peek(",")) {
            return p;
        }
        this.parser.match(",");
        if (this.parser.peek("\"")) {
            p.action = this.expand(this.parser.match("quoted string"));
            if (!this.parser.peek(",")) {
                return p;
            }
            this.parser.match(",");
        }
        try {
            if (this.parser.peek("signedBy")) {
                this.parser.match("signedBy");
                p.signedBy = this.expand(this.parser.match("quoted string"));
            }
        }
        catch (ParserException parserException) {
            FFDCFilter.processException((Throwable)parserException, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"334", (Object)this, (Object[])new Object[0]);
            return null;
        }
        return p;
    }

    String expand(String str) throws ParserException {
        return this.expand(str, false);
    }

    String expand(String str, boolean encodeValue) throws ParserException {
        if (this.expandProp) {
            int strLen = 0;
            if (str == null || (strLen = str.length()) == 0) {
                return str;
            }
            StringBuffer buf = new StringBuffer(strLen + 25);
            int index = 0;
            for (int last = 0; last < strLen; ++last) {
                String value;
                String key;
                index = str.indexOf("${{", last);
                if (index == -1) {
                    index = str.indexOf("${", last);
                    if (index == -1) {
                        buf.append(str.substring(last));
                        break;
                    }
                    buf.append(str.substring(last, index));
                    last = str.indexOf("}", index);
                    if (last == -1) {
                        buf.append(str.substring(index));
                        break;
                    }
                    key = str.substring(index + 2, last);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("key: " + key), (Object[])new Object[0]);
                    }
                    if (key.equals("/")) {
                        buf.append(File.separator);
                        continue;
                    }
                    value = System.getProperty(key);
                    if (value != null) {
                        if (encodeValue) {
                            value = FilePathUtil.encodeFilePath(value);
                        }
                        buf.append(value);
                        continue;
                    }
                    StringBuffer errBuf = new StringBuffer(32);
                    errBuf.append("line ").append(this.parser.getLineNumber()).append(": ");
                    errBuf.append("unable to expand \"").append(key).append("\"");
                    String errStr = errBuf.toString();
                    throw new ParserException(errStr);
                }
                buf.append(str.substring(last, index));
                last = str.indexOf("}", index);
                if (last == -1) {
                    buf.append(str.substring(index));
                    break;
                }
                key = str.substring(index + 3, last);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("key: " + key), (Object[])new Object[0]);
                }
                if (key.equals("/")) {
                    buf.append(File.separator);
                    continue;
                }
                value = System.getProperty(key);
                if (value != null) {
                    if (encodeValue) {
                        value = FilePathUtil.encodeFilePath(value);
                    }
                    buf.append(value);
                    continue;
                }
                StringBuffer errBuf = new StringBuffer(32);
                errBuf.append("line ").append(this.parser.getLineNumber()).append(": ");
                errBuf.append("unable to expand \"").append(key).append("\"");
                String errStr = errBuf.toString();
                throw new ParserException(errStr);
            }
            return buf.toString();
        }
        return str;
    }
}

