/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal.providers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.internal.providers.AbstractLibraryListener;
import com.ibm.ws.classloading.internal.util.RefQueue;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.library.LibraryChangeListener;
import java.lang.ref.WeakReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class WeakLibraryListener
extends WeakReference<Object>
implements LibraryChangeListener {
    private static final RefQueue<Object, WeakLibraryListener> QUEUE;
    private volatile ServiceRegistration<LibraryChangeListener> listenerReg;
    static final long serialVersionUID = 7897203938608289644L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected WeakLibraryListener(String libraryId, String ownerId, Object owner, BundleContext ctx) {
        super(owner, QUEUE);
        WeakLibraryListener.removeStaleListeners();
        this.listenerReg = AbstractLibraryListener.registerListener(this, libraryId, ownerId, ctx);
    }

    private static void removeStaleListeners() {
        WeakLibraryListener ref = QUEUE.poll();
        while (ref != null) {
            ref.deregister();
            ref = QUEUE.poll();
        }
    }

    @Override
    public void libraryNotification() {
        WeakLibraryListener.removeStaleListeners();
        if (this.get() != null) {
            this.update();
        }
    }

    protected abstract void update();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister() {
        ServiceRegistration<LibraryChangeListener> lock = this.listenerReg;
        if (lock == null) {
            return;
        }
        ServiceRegistration<LibraryChangeListener> serviceRegistration = lock;
        synchronized (serviceRegistration) {
            if (this.listenerReg == null) {
                return;
            }
            this.listenerReg.unregister();
            this.listenerReg = null;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.providers.WeakLibraryListener", WeakLibraryListener.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        QUEUE = new RefQueue();
    }
}

