/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal.providers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.internal.providers.AbstractLibraryListener;
import com.ibm.ws.classloading.internal.providers.Providers;
import com.ibm.ws.classloading.internal.util.BlockingList;
import com.ibm.ws.classloading.internal.util.ElementNotReadyException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.library.Library;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class GetLibraries
implements BlockingList.Retriever<String, Library>,
BlockingList.Listener<String, Library> {
    static final TraceComponent tc = Tr.register(GetLibraries.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    private final String ownerID;
    static final long serialVersionUID = -4036398441692219604L;

    GetLibraries(String ownerId) {
        this.ownerID = ownerId;
    }

    @Override
    public Library fetch(String id) throws ElementNotReadyException {
        Library result = Providers.getSharedLibrary(id);
        if (result == null) {
            throw new ElementNotReadyException(id);
        }
        return result;
    }

    @Override
    public void listenFor(final String libraryId, final BlockingList.Slot<? super Library> slot) {
        new AbstractLibraryListener(libraryId, this.ownerID, Providers.bundleContext){
            static final long serialVersionUID = 1927555793581814756L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            void update() {
                String methodName = "update(): ";
                Library library = Providers.getSharedLibrary(libraryId);
                if (library == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("update(): class loader " + GetLibraries.this.ownerID + "received a notification from the shared library " + libraryId + " but the library could not be retrieved."), (Object[])new Object[0]);
                    }
                    return;
                }
                slot.fill(library);
                this.deregister();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.providers.GetLibraries$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        };
    }
}

