/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.SocialLoginConfig;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SocialLoginRequest {
    private static TraceComponent tc = Tr.register(SocialLoginRequest.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    protected SocialLoginConfig socialLoginConfig = null;
    protected String providerName;
    String socialUrlType = null;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected List<SocialLoginConfig> socialLoginConfigs = null;
    static final long serialVersionUID = 4482105142500127023L;

    public SocialLoginRequest(SocialLoginConfig socialLoginConfig, String socialUrlType, HttpServletRequest request, HttpServletResponse response) {
        this.socialLoginConfig = socialLoginConfig;
        this.providerName = socialLoginConfig.getUniqueId();
        this.request = request;
        this.response = response;
        this.socialUrlType = socialUrlType;
    }

    public SocialLoginRequest(String socialUrlType, HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.socialUrlType = socialUrlType;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("request type:" + socialUrlType), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("request url:" + this.getRequestUrl()), (Object[])new Object[0]);
        }
    }

    public String getProviderName() {
        return this.providerName;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public SocialLoginConfig getSocialLoginConfig() {
        return this.socialLoginConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SocialLoginRequest [provider:").append(this.providerName).append(" request:").append(this.request).append("]");
        return sb.toString();
    }

    public String getRequestUrl() {
        StringBuffer sb = this.request.getRequestURL();
        return sb.toString();
    }

    public String getUrlType() {
        return this.socialUrlType;
    }

    public boolean isLogout() {
        return this.socialUrlType.equals("/logout");
    }

    public boolean isWellknownConfig() {
        return this.socialUrlType.equals("/.well-known/configuration");
    }

    public boolean isUnknown() {
        return this.socialUrlType.equals("UNKNOWN");
    }

    public boolean isRedirect() {
        return this.socialUrlType.equals("/redirect/");
    }
}

