/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.config.CommonConfigUtils;
import com.ibm.ws.security.social.SocialLoginService;
import com.ibm.ws.security.social.UserApiConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import java.io.IOException;
import java.util.Dictionary;
import org.osgi.service.cm.Configuration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UserApiConfigImpl
implements UserApiConfig {
    public static final TraceComponent tc = Tr.register(UserApiConfigImpl.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    public static final String KEY_api = "api";
    String api = null;
    public static final String KEY_method = "method";
    String method = null;
    public static final String KEY_parameter = "parameter";
    String parameter = null;
    static final long serialVersionUID = 8883082916123858285L;

    public UserApiConfigImpl(String userApi) {
        this.api = userApi;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("api = " + this.api), (Object[])new Object[0]);
        }
        this.method = "client_secret_basic";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("method = " + this.method), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public UserApiConfigImpl(SocialLoginService parentSocialLoginService, String userinfoRef) throws SocialLoginException {
        Configuration config = null;
        try {
            if (parentSocialLoginService == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No service provided, so nothing to do", (Object[])new Object[0]);
                }
                return;
            }
            config = parentSocialLoginService.getConfigAdmin().getConfiguration(userinfoRef, parentSocialLoginService.getBundleLocation());
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.social.internal.UserApiConfigImpl", (String)"68", (Object)this, (Object[])new Object[]{parentSocialLoginService, userinfoRef});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invalid userinfo configuration", (Object[])new Object[]{userinfoRef});
            }
            throw new SocialLoginException((Exception)e);
        }
        if (config == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("A configuration that matches [" + userinfoRef + "] could not be found"), (Object[])new Object[0]);
            }
            return;
        }
        Dictionary props = config.getProperties();
        if (props == null) {
            return;
        }
        this.api = CommonConfigUtils.trim((String)((String)props.get(KEY_api)));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("api = " + this.api), (Object[])new Object[0]);
        }
        this.method = CommonConfigUtils.trim((String)((String)props.get(KEY_method)));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("method = " + this.method), (Object[])new Object[0]);
        }
        this.parameter = CommonConfigUtils.trim((String)((String)props.get(KEY_parameter)));
    }

    @Override
    public String getApi() {
        return this.api;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getParameter() {
        return this.parameter;
    }
}

